/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.spring.view;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.servlet.View;
import uk.ac.warwick.util.web.spring.view.AlternateAjaxView;

public final class AlternateAjaxViewTest {
    private Mockery m = new JUnit4Mockery();

    @Test
    public void getsToNormalView() throws Exception {
        View ajaxView = (View)this.m.mock(View.class, "ajaxView");
        final View standardView = (View)this.m.mock(View.class, "standardView");
        AlternateAjaxView view = new AlternateAjaxView();
        view.setAjaxView(ajaxView);
        view.setStandardView(standardView);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod("get");
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((View)this.one(standardView)).render((Map)this.with(1.any(Map.class)), (HttpServletRequest)this.with(1.aNonNull(HttpServletRequest.class)), (HttpServletResponse)this.with(1.any(HttpServletResponse.class)));
            }
        });
        HashMap map = Maps.newHashMap();
        view.render((Map)map, (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        Assert.assertTrue((boolean)map.containsKey("ajax"));
        Assert.assertFalse((boolean)((Boolean)map.get("ajax")));
        this.m.assertIsSatisfied();
    }

    @Test
    public void postsToNormalView() throws Exception {
        View ajaxView = (View)this.m.mock(View.class, "ajaxView");
        final View standardView = (View)this.m.mock(View.class, "standardView");
        AlternateAjaxView view = new AlternateAjaxView();
        view.setAjaxView(ajaxView);
        view.setStandardView(standardView);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod("post");
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((View)this.one(standardView)).render((Map)this.with(2.any(Map.class)), (HttpServletRequest)this.with(2.aNonNull(HttpServletRequest.class)), (HttpServletResponse)this.with(2.any(HttpServletResponse.class)));
            }
        });
        HashMap map = Maps.newHashMap();
        view.render((Map)map, (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        Assert.assertTrue((boolean)map.containsKey("ajax"));
        Assert.assertFalse((boolean)((Boolean)map.get("ajax")));
        this.m.assertIsSatisfied();
    }

    @Test
    public void getsToAjaxWithHeader() throws Exception {
        final View ajaxView = (View)this.m.mock(View.class, "ajaxView");
        View standardView = (View)this.m.mock(View.class, "standardView");
        AlternateAjaxView view = new AlternateAjaxView();
        view.setAjaxView(ajaxView);
        view.setStandardView(standardView);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod("get");
        request.addHeader("X-Requested-With", (Object)"XMLHttpRequest");
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((View)this.one(ajaxView)).render((Map)this.with(3.any(Map.class)), (HttpServletRequest)this.with(3.aNonNull(HttpServletRequest.class)), (HttpServletResponse)this.with(3.any(HttpServletResponse.class)));
            }
        });
        HashMap map = Maps.newHashMap();
        view.render((Map)map, (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        Assert.assertTrue((boolean)map.containsKey("ajax"));
        Assert.assertTrue((boolean)((Boolean)map.get("ajax")));
        this.m.assertIsSatisfied();
    }

    @Test
    public void postsToAjaxWithHeader() throws Exception {
        final View ajaxView = (View)this.m.mock(View.class, "ajaxView");
        View standardView = (View)this.m.mock(View.class, "standardView");
        AlternateAjaxView view = new AlternateAjaxView();
        view.setAjaxView(ajaxView);
        view.setStandardView(standardView);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod("post");
        request.addHeader("X-Requested-With", (Object)"XMLHttpRequest");
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((View)this.one(ajaxView)).render((Map)this.with(4.any(Map.class)), (HttpServletRequest)this.with(4.aNonNull(HttpServletRequest.class)), (HttpServletResponse)this.with(4.any(HttpServletResponse.class)));
            }
        });
        HashMap map = Maps.newHashMap();
        view.render((Map)map, (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        Assert.assertTrue((boolean)map.containsKey("ajax"));
        Assert.assertTrue((boolean)((Boolean)map.get("ajax")));
        this.m.assertIsSatisfied();
    }

    @Test
    public void getsToAjaxWithParameter() throws Exception {
        final View ajaxView = (View)this.m.mock(View.class, "ajaxView");
        View standardView = (View)this.m.mock(View.class, "standardView");
        AlternateAjaxView view = new AlternateAjaxView();
        view.setAjaxView(ajaxView);
        view.setStandardView(standardView);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod("get");
        request.setParameter("ajax", "true");
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((View)this.one(ajaxView)).render((Map)this.with(5.any(Map.class)), (HttpServletRequest)this.with(5.aNonNull(HttpServletRequest.class)), (HttpServletResponse)this.with(5.any(HttpServletResponse.class)));
            }
        });
        HashMap map = Maps.newHashMap();
        view.render((Map)map, (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        Assert.assertTrue((boolean)map.containsKey("ajax"));
        Assert.assertTrue((boolean)((Boolean)map.get("ajax")));
        this.m.assertIsSatisfied();
    }

    @Test
    public void postsToAjaxWithParameter() throws Exception {
        final View ajaxView = (View)this.m.mock(View.class, "ajaxView");
        View standardView = (View)this.m.mock(View.class, "standardView");
        AlternateAjaxView view = new AlternateAjaxView();
        view.setAjaxView(ajaxView);
        view.setStandardView(standardView);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod("post");
        request.setParameter("ajax", "true");
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((View)this.one(ajaxView)).render((Map)this.with(6.any(Map.class)), (HttpServletRequest)this.with(6.aNonNull(HttpServletRequest.class)), (HttpServletResponse)this.with(6.any(HttpServletResponse.class)));
            }
        });
        HashMap map = Maps.newHashMap();
        view.render((Map)map, (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        Assert.assertTrue((boolean)map.containsKey("ajax"));
        Assert.assertTrue((boolean)((Boolean)map.get("ajax")));
        this.m.assertIsSatisfied();
    }
}

