/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.filter.stack;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import uk.ac.warwick.util.web.filter.stack.CompositeFilter;
import uk.ac.warwick.util.web.filter.stack.MockFilter;

public class CompositeFilterTest {
    private MockFilter f1;
    private MockFilter f2;
    private MockFilter f3;
    private MockFilter f4;
    private List<Filter> filters;
    private MockHttpServletRequest req;
    private MockHttpServletResponse res;
    private MockFilterChain filterChain;

    @Before
    public void setUp() throws Exception {
        this.f1 = new MockFilter(true);
        this.f2 = new MockFilter(true);
        this.f3 = new MockFilter(true);
        this.f4 = new MockFilter(false);
        this.req = new MockHttpServletRequest();
        this.res = new MockHttpServletResponse();
        this.filterChain = new MockFilterChain();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void allFiltersRun() throws Exception {
        this.filters = Arrays.asList(this.f1, this.f2, this.f3);
        CompositeFilter filter = new CompositeFilter(this.filters);
        filter.doFilter((ServletRequest)this.req, (ServletResponse)this.res, (FilterChain)this.filterChain);
        Assert.assertEquals((long)1L, (long)this.f1.getInvocationCount());
        Assert.assertEquals((long)1L, (long)this.f2.getInvocationCount());
        Assert.assertEquals((long)1L, (long)this.f3.getInvocationCount());
        Assert.assertSame((Object)this.req, (Object)this.filterChain.getRequest());
        Assert.assertSame((Object)this.res, (Object)this.filterChain.getResponse());
    }

    @Test
    public void failedFilter() throws Exception {
        this.filters = Arrays.asList(this.f1, this.f2, this.f4, this.f3);
        CompositeFilter filter = new CompositeFilter(this.filters);
        filter.doFilter((ServletRequest)this.req, (ServletResponse)this.res, (FilterChain)this.filterChain);
        Assert.assertEquals((long)1L, (long)this.f1.getInvocationCount());
        Assert.assertEquals((long)1L, (long)this.f2.getInvocationCount());
        Assert.assertEquals((long)1L, (long)this.f4.getInvocationCount());
        Assert.assertEquals((long)0L, (long)this.f3.getInvocationCount());
        Assert.assertNull((Object)this.filterChain.getRequest());
        Assert.assertNull((Object)this.filterChain.getResponse());
    }

    @Test
    public void requestObjectChanges() throws Exception {
        MockHttpServletRequest swappedRequest = new MockHttpServletRequest();
        this.f2.setSwapRequest((ServletRequest)swappedRequest);
        this.filters = Arrays.asList(this.f1, this.f2, this.f3);
        CompositeFilter filter = new CompositeFilter(this.filters);
        filter.doFilter((ServletRequest)this.req, (ServletResponse)this.res, (FilterChain)this.filterChain);
        Assert.assertEquals((long)1L, (long)this.f1.getInvocationCount());
        Assert.assertEquals((long)1L, (long)this.f2.getInvocationCount());
        Assert.assertEquals((long)1L, (long)this.f3.getInvocationCount());
        Assert.assertSame((Object)swappedRequest, (Object)this.filterChain.getRequest());
        Assert.assertSame((Object)this.res, (Object)this.filterChain.getResponse());
    }

    @Test
    public void flattening() throws Exception {
        CompositeFilter filter1 = new CompositeFilter(Arrays.asList(this.f1, this.f2, this.f3));
        CompositeFilter filter2 = new CompositeFilter(Arrays.asList(this.f1, filter1, this.f1));
        Assert.assertEquals((long)5L, (long)filter2.getFilters().size());
        CompositeFilter filter3 = new CompositeFilter(Arrays.asList(this.f1, filter1, this.f1), false);
        Assert.assertEquals((long)3L, (long)filter3.getFilters().size());
        Assert.assertSame((Object)filter1, filter3.getFilters().get(1));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void cannotModifyFilters() throws Exception {
        this.filters = Arrays.asList(this.f1, this.f2, this.f3);
        CompositeFilter filter = new CompositeFilter(this.filters);
        filter.getFilters().clear();
    }

    @Test
    public void afterChain() throws Exception {
        Filter f = new Filter(){

            public void doFilter(ServletRequest arg0, ServletResponse arg1, FilterChain arg2) throws IOException, ServletException {
                Assert.assertFalse((String)"first filter shouldn't have returned while still in second filter", (boolean)CompositeFilterTest.this.f1.isFinished());
            }

            public void destroy() {
            }

            public void init(FilterConfig config) throws ServletException {
            }
        };
        this.filters = Arrays.asList(this.f1, f);
        CompositeFilter filter = new CompositeFilter(this.filters);
        filter.doFilter((ServletRequest)this.req, (ServletResponse)this.res, (FilterChain)this.filterChain);
    }
}

