/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.bind;

import java.time.LocalDateTime;
import java.time.Month;
import java.time.temporal.ChronoField;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.web.bind.LocalDateTimePropertyEditor;

public final class LocalDateTimePropertyEditorTest {
    @Test(expected=IllegalArgumentException.class)
    public void cantInstantiateWithoutFormats() throws Exception {
        new LocalDateTimePropertyEditor(new String[0], true);
        Assert.fail((String)"expected exception");
    }

    @Test
    public void fallsBackForYear() throws Exception {
        LocalDateTimePropertyEditor editor = new LocalDateTimePropertyEditor(new String[]{"HH:mm dd/MM/yy", "HH:mm dd/MM/yyyy"}, true);
        editor.setAsText("00:00 12/01/2009");
        LocalDateTime output = (LocalDateTime)editor.getValue();
        Assert.assertNotNull((Object)output);
        Assert.assertEquals((long)0L, (long)output.getLong(ChronoField.MILLI_OF_DAY));
        Assert.assertEquals((long)12L, (long)output.getDayOfMonth());
        Assert.assertEquals((Object)Month.JANUARY, (Object)output.getMonth());
        Assert.assertEquals((long)2009L, (long)output.getYear());
        Assert.assertEquals((Object)"00:00 12/01/09", (Object)editor.getAsText());
        editor.setAsText("00:00 12/01/09");
        output = (LocalDateTime)editor.getValue();
        Assert.assertNotNull((Object)output);
        Assert.assertEquals((long)0L, (long)output.getLong(ChronoField.MILLI_OF_DAY));
        Assert.assertEquals((long)12L, (long)output.getDayOfMonth());
        Assert.assertEquals((Object)Month.JANUARY, (Object)output.getMonth());
        Assert.assertEquals((long)2009L, (long)output.getYear());
    }

    @Test
    public void lenientParsing() throws Exception {
        LocalDateTimePropertyEditor editor = new LocalDateTimePropertyEditor("ddMMyyHHmm", false, true);
        editor.setAsText("3109090900");
        LocalDateTime output = (LocalDateTime)editor.getValue();
        Assert.assertNotNull((Object)output);
        Assert.assertEquals((long)0L, (long)output.getLong(ChronoField.MILLI_OF_SECOND));
        Assert.assertEquals((long)9L, (long)output.getHour());
        Assert.assertEquals((long)0L, (long)output.getMinute());
        Assert.assertEquals((long)1L, (long)output.getDayOfMonth());
        Assert.assertEquals((Object)Month.OCTOBER, (Object)output.getMonth());
        Assert.assertEquals((long)2009L, (long)output.getYear());
        Assert.assertEquals((Object)"0110090900", (Object)editor.getAsText());
    }
}

