/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.tags;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public final class EnumValuesTag
extends TagSupport {
    private static final long serialVersionUID = 6819886693312533932L;
    private String var;
    private String className;

    public int doStartTag() throws JspException {
        List<?> values = EnumValuesTag.getValues(this.className);
        this.pageContext.setAttribute(this.var, values);
        return 1;
    }

    public static List<?> getValues(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (!clazz.isEnum()) {
                throw new IllegalStateException("Not an enum class: " + className);
            }
            Method valuesMethod = clazz.getMethod("values", new Class[0]);
            return Lists.newArrayList((Object[])((Object[])valuesMethod.invoke(null, new Object[0])));
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid enum class: " + className, e);
        }
    }

    public int doEndTag() throws JspException {
        this.pageContext.removeAttribute(this.var);
        return super.doEndTag();
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }
}

