/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.spring.view.json;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.servlet.View;
import uk.ac.warwick.util.web.spring.view.json.JSON;
import uk.ac.warwick.util.web.spring.view.json.JSONPRequestValidator;

@Configurable
abstract class AbstractJSONView<T>
implements View {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJSONView.class);
    private static final int OUTPUT_BYTE_ARRAY_INITIAL_SIZE = 4096;
    private static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    @Autowired(required=true)
    private transient JSONPRequestValidator jsonpRequestValidator = JSONPRequestValidator.REJECT_ALL;
    private boolean wrapErrors = true;

    AbstractJSONView() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void render(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSON<?> results = this.getValue(model, request);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, this.getCharacterEncoding());){
            String contentType = this.getContentType();
            String callback = this.getParam(request, "jsonp", "callback");
            if (StringUtils.hasText((String)callback) && this.jsonpRequestValidator.isAllow(request)) {
                writer.write(callback + "(");
                results.write(writer);
                writer.write(");");
                contentType = "application/javascript";
            } else {
                String assignment = this.getParam(request, "assign");
                if (StringUtils.hasText((String)assignment) && this.jsonpRequestValidator.isAllow(request)) {
                    writer.write("var " + assignment + " = ");
                    results.write(writer);
                    writer.write(";");
                    contentType = "application/javascript";
                } else {
                    results.write(writer);
                }
            }
            writer.flush();
            this.writeToResponse(response, baos, contentType);
        }
    }

    private JSON<?> getValue(Map<String, Object> model, HttpServletRequest request) throws JSONException, ServletException {
        if (this.wrapErrors) {
            JSONObject results = new JSONObject();
            JSONArray errors = new JSONArray();
            JSON<T> data = null;
            ArrayList errorsList = Lists.newArrayList();
            try {
                data = this.renderToJSON(model, request, errorsList);
                for (String error : errorsList) {
                    errors.put((Object)error);
                }
            }
            catch (Exception e) {
                errors.put((Object)("Uncaught exception: " + e.getMessage()));
                LOGGER.error("Error processing JSON view", (Throwable)e);
            }
            results.put("data", data == null ? JSONObject.NULL : data.unwrap());
            results.put("errors", (Object)errors);
            return JSON.wrap(results);
        }
        try {
            return this.renderToJSON(model, request, Lists.newArrayList());
        }
        catch (Exception e) {
            LOGGER.error("Error processing JSON view", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    public abstract JSON<T> renderToJSON(Map<String, Object> var1, HttpServletRequest var2, List<String> var3) throws Exception;

    private void writeToResponse(HttpServletResponse response, ByteArrayOutputStream baos, String contentType) throws IOException {
        response.setContentType(contentType);
        response.setContentLength(baos.size());
        ServletOutputStream out = response.getOutputStream();
        baos.writeTo((OutputStream)out);
        out.flush();
    }

    private String getParam(HttpServletRequest request, String ... params) throws ServletRequestBindingException {
        for (String param : params) {
            String result = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)param);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public String getCharacterEncoding() {
        return DEFAULT_CHARACTER_ENCODING;
    }

    public final String getContentType() {
        return "application/json";
    }

    public final void setJsonpRequestValidator(JSONPRequestValidator jsonpRequestValidator) {
        this.jsonpRequestValidator = jsonpRequestValidator;
    }

    public final JSONPRequestValidator getJsonpRequestValidator() {
        return this.jsonpRequestValidator;
    }

    public final void setWrapErrors(boolean wrapErrors) {
        this.wrapErrors = wrapErrors;
    }

    public final void setJsonpRequestValidatorAsString(String validator) {
        if ("ALLOW_ALL".equals(validator)) {
            this.jsonpRequestValidator = JSONPRequestValidator.ALLOW_ALL;
        } else if ("REJECT_ALL".equals(validator)) {
            this.jsonpRequestValidator = JSONPRequestValidator.REJECT_ALL;
        } else {
            throw new IllegalArgumentException();
        }
    }
}

