/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.filter.stack;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.warwick.util.web.filter.stack.FilterMappingParser;

public final class FilterMappingParserImpl
implements FilterMappingParser {
    private static final Pattern SLASH_PREFIXED_WILDCARDS_AT_END = Pattern.compile("(?<!\\.)\\/\\*$");
    private static final Pattern ONE_CHARACTER_WILDCARD = Pattern.compile("\\?");
    private static final Pattern MATCH_ONE_CHARACTER = Pattern.compile(".");
    private static final Pattern EXTENSION_SUFFIXED_WILDCARD = Pattern.compile("\\.\\*(?!\\.)");
    private static final Pattern MATCH_WITHOUT_SLASHES = Pattern.compile("\\.[^\\/]+");
    private static final Pattern EXTENSION_PREFIXED_WILDCARD = Pattern.compile("(?<!\\.)\\*\\.");
    private static final Pattern MATCH_DOT_PREFIXED_ANYTHING = Pattern.compile(".+\\.");
    private static final Pattern MATCH_WILDCARD_WITH_OPTIONAL_SLASH = Pattern.compile("(?:\\/.*)?");
    private static final Pattern NON_EXTENSION_WILDCARD = Pattern.compile("(?<!\\.)\\*(?!\\.)");
    private static final Pattern MATCH_ANYTHING = Pattern.compile(".*");

    @Override
    public boolean matches(String requestPath, String mapping) {
        return requestPath.matches(FilterMappingParserImpl.handleSlashPrefixedWildcards(mapping));
    }

    private static String handleSlashPrefixedWildcards(String str) {
        return "^" + FilterMappingParserImpl.genericHandle(str, FilterMappingParserImpl::handleGeneralWildcards, SLASH_PREFIXED_WILDCARDS_AT_END, MATCH_WILDCARD_WITH_OPTIONAL_SLASH, 1) + "$";
    }

    private static String handleGeneralWildcards(String str) {
        return FilterMappingParserImpl.genericHandle(str, FilterMappingParserImpl::handleOneCharacterWildcards, NON_EXTENSION_WILDCARD, MATCH_ANYTHING, 1);
    }

    private static String handleOneCharacterWildcards(String str) {
        return FilterMappingParserImpl.genericHandle(str, FilterMappingParserImpl::handleStartingExtensions, ONE_CHARACTER_WILDCARD, MATCH_ONE_CHARACTER, 1);
    }

    private static String handleStartingExtensions(String str) {
        return FilterMappingParserImpl.genericHandle(str, FilterMappingParserImpl::handleEndingExtensions, EXTENSION_SUFFIXED_WILDCARD, MATCH_WITHOUT_SLASHES, 2);
    }

    private static String handleEndingExtensions(String str) {
        return FilterMappingParserImpl.genericHandle(str, Pattern::quote, EXTENSION_PREFIXED_WILDCARD, MATCH_DOT_PREFIXED_ANYTHING, 2);
    }

    private static String genericHandle(String str, Function<String, String> callback, Pattern pattern, Pattern patternToAppend, int offset) {
        StringBuilder intermediateRegex = new StringBuilder();
        Matcher matcher = pattern.matcher(str);
        int beginning = 0;
        while (matcher.find()) {
            int start = matcher.start();
            intermediateRegex.append(callback.apply(str.substring(beginning, start))).append(patternToAppend);
            beginning = matcher.end();
        }
        if (!str.substring(beginning).isEmpty()) {
            intermediateRegex.append(callback.apply(str.substring(beginning)));
        }
        return intermediateRegex.toString();
    }
}

