/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.filter;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.util.web.filter.AbstractHttpFilter;

public class RequestThreadFilter
extends AbstractHttpFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestThreadFilter.class);
    private final ConcurrentMap<Thread, RequestData> map = new ConcurrentHashMap<Thread, RequestData>();
    private final ObjectPool<RequestData> dataPool = new GenericObjectPool((PooledObjectFactory)new RequestDataFactory(), (GenericObjectPoolConfig)new GenericObjectPoolConfig<RequestData>(){
        {
            this.setMaxTotal(Integer.MAX_VALUE);
            this.setMaxIdle(100);
            this.setMinIdle(50);
            this.setLifo(true);
        }
    });

    public RequestData get(Thread t) {
        return (RequestData)this.map.get(t);
    }

    public Map<Thread, RequestData> getAll() {
        return Collections.unmodifiableMap(this.map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        RequestData data = null;
        Thread thread = Thread.currentThread();
        try {
            String ip = (String)req.getAttribute("REMOTE_IP_ADDRESS_STRING");
            if (ip == null) {
                ip = req.getRemoteHost();
            }
            if ((data = this.borrowRequestData()) != null) {
                data.init(req.getMethod(), ip, req.getRequestURL(), req.getQueryString());
                if (this.map.put(thread, data) != null) {
                    LOGGER.error("Filter is overwriting an existing Thread key!");
                }
            }
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        }
        finally {
            this.map.remove(thread);
            if (data != null) {
                try {
                    this.dataPool.returnObject((Object)data);
                }
                catch (Exception e) {
                    LOGGER.error("Did not expect to fail returning object to pool", (Throwable)e);
                }
            }
        }
    }

    private RequestData borrowRequestData() {
        try {
            return (RequestData)this.dataPool.borrowObject();
        }
        catch (Exception e) {
            LOGGER.error("Failed to get a RequestData", (Throwable)e);
            return null;
        }
    }

    static final class RequestDataFactory
    extends BasePooledObjectFactory<RequestData> {
        RequestDataFactory() {
        }

        public RequestData create() {
            return new RequestData();
        }

        public PooledObject<RequestData> wrap(RequestData requestData) {
            return new DefaultPooledObject((Object)requestData);
        }
    }

    public static final class RequestData {
        private StringBuffer requestURL;
        private String ip;
        private String query;
        private String method;
        private long createdTime;

        public void init(String method, String ip, StringBuffer url, String queryString) {
            this.method = method;
            this.requestURL = url;
            this.ip = ip;
            this.query = queryString;
            this.createdTime = System.currentTimeMillis();
        }

        public String getRequestURL() {
            return this.requestURL.toString();
        }

        public String getIp() {
            return this.ip;
        }

        public String getQuery() {
            return this.query;
        }

        public String getMethod() {
            return this.method;
        }

        public long getCreatedTime() {
            return this.createdTime;
        }
    }
}

