/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.bind;

import java.beans.PropertyEditorSupport;
import uk.ac.warwick.util.core.StringUtils;
import uk.ac.warwick.util.web.bind.TrimmedStringPropertyEditor;

public final class TrimAndEscapeStringPropertyEditor
extends PropertyEditorSupport {
    private TrimmedStringPropertyEditor trimmer = new TrimmedStringPropertyEditor();

    public TrimAndEscapeStringPropertyEditor() {
        this.setValue("");
    }

    public void setValue(String value) {
        this.trimmer.setValue(value);
        super.setValue(StringUtils.htmlEscapeHighCharacters((String)this.trimmer.getAsText()));
    }

    @Override
    public String getValue() {
        this.trimmer.setValue(super.getValue());
        return this.escape(this.trimmer.getAsText());
    }

    @Override
    public void setAsText(String text) {
        this.setValue(text);
    }

    @Override
    public String getAsText() {
        return StringUtils.nullGuard((String)("" + this.getValue()));
    }

    private String escape(String text) {
        return StringUtils.htmlEscapeHighCharacters((String)text);
    }
}

