/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web;

import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.util.StringUtils;
import uk.ac.warwick.util.web.Uri;

public final class WarwickHttpServletRequest
extends HttpServletRequestWrapper {
    public static final String REQUESTED_URI_HEADER_NAME = "X-Requested-URI";
    public static final String FORWARDED_FOR_HEADER_NAME = "X-Forwarded-For";
    public static final Pattern IP_ADDRESS_PATTERN = Pattern.compile("[0-9]{1,3}(:?\\.[0-9]{1,3}){3}");
    private final Set<String> localAddresses;

    public WarwickHttpServletRequest(HttpServletRequest request, Set<String> theLocalAddresses) {
        super(request);
        this.localAddresses = theLocalAddresses;
    }

    public String getHeader(String name) {
        String requestedUrl;
        if ("Host".equals(name) && StringUtils.hasText((String)(requestedUrl = this.getRequestedURL()))) {
            try {
                return Uri.parse(requestedUrl).getAuthority();
            }
            catch (Uri.UriException e) {
                return super.getHeader(name);
            }
        }
        return super.getHeader(name);
    }

    public String getRemoteAddr() {
        String xForwardedFor = this.getHeader(FORWARDED_FOR_HEADER_NAME);
        if (xForwardedFor != null) {
            String[] addresses = xForwardedFor.split(",");
            for (int i = 0; i < addresses.length; ++i) {
                String address = addresses[i].trim();
                if (!IP_ADDRESS_PATTERN.matcher(address).matches() || !this.isNonLocalAddress(address)) continue;
                return address;
            }
        }
        return super.getRemoteAddr();
    }

    private boolean isNonLocalAddress(String address) {
        String[] bits;
        int secondOctet;
        int private20bitLower = 16;
        int private20bitUpper = 31;
        int hotspot20bitLower = 31;
        int hotspot20bitUpper = 31;
        boolean local = false;
        if (this.localAddresses.contains(address)) {
            local = true;
        } else if ("127.0.0.1".equals(address) || address.startsWith("10.") || address.startsWith("192.168") || address.startsWith("169.254")) {
            local = true;
        } else if (address.startsWith("172") && (secondOctet = Integer.parseInt((bits = address.split("\\."))[1])) >= 16 && secondOctet <= 31 && (secondOctet < 31 || secondOctet > 31)) {
            local = true;
        }
        return !local;
    }

    public String getRequestURI() {
        Uri url = this.getUri();
        return url == null ? super.getRequestURI() : url.getPath();
    }

    public StringBuffer getRequestURL() {
        String requestedUrl = this.getRequestedURL();
        if (StringUtils.hasText((String)requestedUrl)) {
            return new StringBuffer(requestedUrl);
        }
        return super.getRequestURL();
    }

    private String getRequestedURL() {
        return this.getHeader(REQUESTED_URI_HEADER_NAME);
    }

    private Uri getUri() {
        String requestedUrl = this.getRequestedURL();
        if (StringUtils.hasText((String)requestedUrl)) {
            return Uri.parse(requestedUrl);
        }
        return null;
    }

    public String getQueryString() {
        Uri url = this.getUri();
        return url == null ? super.getQueryString() : url.getQuery();
    }

    public String getScheme() {
        Uri url = this.getUri();
        return url == null ? super.getScheme() : url.getScheme();
    }

    public String getServerName() {
        Uri url = this.getUri();
        return url == null ? super.getServerName() : this.getServerName(url.getAuthority());
    }

    public int getServerPort() {
        Uri url = this.getUri();
        if (url != null) {
            int port = this.getServerPort(url.getAuthority());
            return port > 0 ? port : this.getDefaultPort(url.getScheme());
        }
        return super.getServerPort();
    }

    private String getServerName(String authority) {
        if (authority.indexOf(":") == -1) {
            return authority;
        }
        return authority.substring(0, authority.lastIndexOf(":"));
    }

    private int getServerPort(String authority) {
        if (authority.indexOf(":") == -1) {
            return 0;
        }
        String[] parts = authority.split(":");
        return Integer.parseInt(parts[parts.length - 1]);
    }

    private int getDefaultPort(String scheme) {
        if ("http".equals(scheme)) {
            return 80;
        }
        if ("https".equals(scheme)) {
            return 443;
        }
        throw new IllegalStateException("Invalid scheme: " + scheme);
    }

    public boolean isSecure() {
        return this.getServerPort() == 443 || this.getServerPort() == 8443;
    }
}

