/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web;

import uk.ac.warwick.util.web.Uri;
import uk.ac.warwick.util.web.UriBuilder;

public abstract class UriUtils {
    private UriUtils() {
    }

    public static Uri sanitise(Uri url) {
        if (url.getScheme() == null) {
            UriBuilder uriBuilder = new UriBuilder(url).setScheme("http");
            if (uriBuilder.getAuthority() == null && uriBuilder.getPath() != null) {
                String path = uriBuilder.getPath();
                if (path.indexOf("/") == -1) {
                    uriBuilder.setAuthority(path).setPath(null);
                } else {
                    uriBuilder.setAuthority(path.substring(0, path.indexOf("/"))).setPath(path.substring(path.indexOf("/") + 1));
                }
            }
            return uriBuilder.toUri();
        }
        return url;
    }
}

