/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.tags;

import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import junit.framework.TestCase;
import org.springframework.mock.web.MockBodyContent;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockPageContext;
import uk.ac.warwick.util.web.tags.CompressContentTag;

public class CompressContentTagTest
extends TestCase {
    public void testExcessiveCompression() throws Exception {
        String input = "<input\n                           type=\"hidden\"\n                           name=\"editor\"\n                           value=\"editMceContent\"\n                            />";
        String expected = "<input type=\"hidden\" name=\"editor\" value=\"editMceContent\" />";
        CompressContentTag tag = new CompressContentTag();
        CompressContentTagTest.assertEquals((String)expected, (String)this.doTag(tag, input));
    }

    public void testRemoveInterTagSpaces() throws Exception {
        String input = "<input type=\"hidden\" name=\"a\" />\n   <input type=\"hidden\" name=\"b\" />";
        String withSpace = "<input type=\"hidden\" name=\"a\" /> <input type=\"hidden\" name=\"b\" />";
        String withoutSpace = "<input type=\"hidden\" name=\"a\" /><input type=\"hidden\" name=\"b\" />";
        CompressContentTag tag = new CompressContentTag();
        CompressContentTagTest.assertEquals((String)withSpace, (String)this.doTag(tag, input));
        CompressContentTag tag2 = new CompressContentTag();
        tag2.setRemoveInterTagSpaces(true);
        CompressContentTagTest.assertEquals((String)withoutSpace, (String)this.doTag(tag2, input));
    }

    private String doTag(CompressContentTag tag, String body) throws Exception {
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        MockBodyContent content = new MockBodyContent(body, (HttpServletResponse)mockResponse);
        MockPageContext context = new MockPageContext(null, null, (HttpServletResponse)mockResponse);
        tag.setBodyContent((BodyContent)content);
        tag.setPageContext((PageContext)context);
        tag.doEndTag();
        return mockResponse.getContentAsString();
    }
}

