/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.spring.view.json;

import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import uk.ac.warwick.util.web.spring.view.json.SameOriginHostJSONPRequestValidator;

public final class SameOriginHostJSONPRequestValidatorTest {
    @Test
    public void noRefererUsesDefault() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        SameOriginHostJSONPRequestValidator validator = new SameOriginHostJSONPRequestValidator("www2.warwick.ac.uk");
        validator.setValidByDefault(true);
        Assert.assertTrue((boolean)validator.isAllow((HttpServletRequest)request));
        validator.setValidByDefault(false);
        Assert.assertFalse((boolean)validator.isAllow((HttpServletRequest)request));
    }

    @Test
    public void differentReferer() throws Exception {
        SameOriginHostJSONPRequestValidator validator = new SameOriginHostJSONPRequestValidator("www2.warwick.ac.uk");
        validator.setValidByDefault(false);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("referer", (Object)"http://start.warwick.ac.uk/malicious.jsp");
        Assert.assertFalse((boolean)validator.isAllow((HttpServletRequest)request));
    }

    @Test
    public void differentRefererWithFullURLConstructor() throws Exception {
        SameOriginHostJSONPRequestValidator validator = new SameOriginHostJSONPRequestValidator("http://www2.warwick.ac.uk/");
        validator.setValidByDefault(false);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("referer", (Object)"http://start.warwick.ac.uk/malicious.jsp");
        Assert.assertFalse((boolean)validator.isAllow((HttpServletRequest)request));
    }

    @Test
    public void sameHostReferer() throws Exception {
        SameOriginHostJSONPRequestValidator validator = new SameOriginHostJSONPRequestValidator("www2.warwick.ac.uk");
        validator.setValidByDefault(false);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("referer", (Object)"http://www2.warwick.ac.uk/nice.jsp");
        Assert.assertTrue((boolean)validator.isAllow((HttpServletRequest)request));
    }

    @Test
    public void sameHostRefererWithFullURLConstructor() throws Exception {
        SameOriginHostJSONPRequestValidator validator = new SameOriginHostJSONPRequestValidator("http://www2.warwick.ac.uk/");
        validator.setValidByDefault(false);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("referer", (Object)"http://www2.warwick.ac.uk/nice.jsp");
        Assert.assertTrue((boolean)validator.isAllow((HttpServletRequest)request));
    }
}

