/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.filter.stack;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.Sequence;
import org.jmock.api.Action;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockFilterConfig;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.filter.GenericFilterBean;
import uk.ac.warwick.util.MockUtils;
import uk.ac.warwick.util.web.filter.stack.ConfigurableFilterStack;
import uk.ac.warwick.util.web.filter.stack.FilterStackSet;

public class ConfigurableFilterStackTest {
    ConfigurableFilterStack filter;
    Mockery ctx;
    MockHttpServletRequest request;
    MockHttpServletResponse response;
    private Filter f1;
    private Filter f2;
    private Filter f3;

    @Before
    public void setup() {
        this.ctx = new Mockery();
        this.request = new MockHttpServletRequest();
        this.response = new MockHttpServletResponse();
        this.request.setRequestURI("/render/renderPage.htm");
        this.f1 = (Filter)this.ctx.mock(Filter.class, "f1");
        this.f2 = (Filter)this.ctx.mock(Filter.class, "f2");
        this.f3 = (Filter)this.ctx.mock(Filter.class, "f3");
    }

    @After
    public void tearDown() {
        if (this.filter != null) {
            this.filter.getCache().invalidateAll();
        }
    }

    @Test
    public void singleStackSet() throws Exception {
        this.checkingFiltersRunInOrder();
        List<Filter> filters = Arrays.asList(this.f1, this.f2, this.f3);
        FilterStackSet set = new FilterStackSet(filters, Arrays.asList("/render/*"));
        this.filter = new ConfigurableFilterStack(Arrays.asList(set));
        this.filter.afterPropertiesSet();
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)new MockFilterChain());
        this.ctx.assertIsSatisfied();
    }

    @Test
    public void twoStackSets() throws Exception {
        this.checkingFiltersRunInOrder();
        FilterStackSet set1 = new FilterStackSet(Arrays.asList(this.f1, this.f2), Arrays.asList("/render/*"));
        FilterStackSet set2 = new FilterStackSet(Arrays.asList(this.f3), Arrays.asList("/*"));
        this.filter = new ConfigurableFilterStack(Arrays.asList(set1, set2));
        this.filter.afterPropertiesSet();
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)new MockFilterChain());
        this.ctx.assertIsSatisfied();
    }

    @Test
    public void twoStackSetsSameFilter() throws Exception {
        this.ctx.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence filterOrder = ConfigurableFilterStackTest.this.ctx.sequence("filterOrder");
                ((Filter)this.exactly(2).of((Object)ConfigurableFilterStackTest.this.f1)).doFilter((ServletRequest)this.with(1.same((Object)ConfigurableFilterStackTest.this.request)), (ServletResponse)this.with(1.same((Object)ConfigurableFilterStackTest.this.response)), (FilterChain)this.with(1.any(FilterChain.class)));
                this.will(MockUtils.continueFilterChain());
                this.inSequence(filterOrder);
            }
        });
        FilterStackSet set1 = new FilterStackSet(Arrays.asList(this.f1), Arrays.asList("/render/*"));
        FilterStackSet set2 = new FilterStackSet(Arrays.asList(this.f1), Arrays.asList("/render/*"));
        this.filter = new ConfigurableFilterStack(Arrays.asList(set1, set2));
        this.filter.afterPropertiesSet();
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)new MockFilterChain());
        this.ctx.assertIsSatisfied();
    }

    @Test
    public void exclusion() throws Exception {
        this.ctx.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence filterOrder = ConfigurableFilterStackTest.this.ctx.sequence("filterOrder");
                this.never(ConfigurableFilterStackTest.this.f1);
                this.will(MockUtils.continueFilterChain());
                this.inSequence(filterOrder);
            }
        });
        FilterStackSet set = new FilterStackSet(Arrays.asList(this.f1), Arrays.asList("/api/dataentry/*"), Arrays.asList("/api/*/entries.*"));
        this.filter = new ConfigurableFilterStack(Arrays.asList(set));
        this.filter.afterPropertiesSet();
        this.request.setRequestURI("/api/dataentry/entries.json");
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)new MockFilterChain());
        this.ctx.assertIsSatisfied();
    }

    @Test
    public void twoStackSetsOneMatch() throws Exception {
        this.ctx.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence filterOrder = ConfigurableFilterStackTest.this.ctx.sequence("filterOrder");
                ((Filter)this.one(ConfigurableFilterStackTest.this.f1)).doFilter((ServletRequest)this.with(3.same((Object)ConfigurableFilterStackTest.this.request)), (ServletResponse)this.with(3.same((Object)ConfigurableFilterStackTest.this.response)), (FilterChain)this.with(3.any(FilterChain.class)));
                this.will(MockUtils.continueFilterChain());
                this.inSequence(filterOrder);
                ((Filter)this.one(ConfigurableFilterStackTest.this.f2)).doFilter((ServletRequest)this.with(3.same((Object)ConfigurableFilterStackTest.this.request)), (ServletResponse)this.with(3.same((Object)ConfigurableFilterStackTest.this.response)), (FilterChain)this.with(3.any(FilterChain.class)));
                this.will(MockUtils.continueFilterChain());
                this.inSequence(filterOrder);
                this.never(ConfigurableFilterStackTest.this.f3);
            }
        });
        FilterStackSet set1 = new FilterStackSet(Arrays.asList(this.f1, this.f2), Arrays.asList("/render/*"));
        FilterStackSet set2 = new FilterStackSet(Arrays.asList(this.f3), Arrays.asList("*.css"));
        this.filter = new ConfigurableFilterStack(Arrays.asList(set1, set2));
        this.filter.afterPropertiesSet();
        MockFilterChain chain = new MockFilterChain();
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)chain);
        Assert.assertNotNull((String)"should continue chain even if match not made", (Object)chain.getRequest());
        this.ctx.assertIsSatisfied();
    }

    @Test
    public void genericFilterBeanInit() throws Exception {
        GenericFilterBean f = new GenericFilterBean(){

            public void doFilter(ServletRequest arg0, ServletResponse arg1, FilterChain arg2) throws IOException, ServletException {
            }
        };
        FilterStackSet set = new FilterStackSet(Arrays.asList(f), Arrays.asList("*.css"));
        this.filter = new ConfigurableFilterStack(Arrays.asList(set));
        MockFilterConfig cfg = new MockFilterConfig("helloFilter");
        this.filter.init((FilterConfig)cfg);
    }

    private void checkingFiltersRunInOrder() throws IOException, ServletException {
        this.ctx.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence filterOrder = ConfigurableFilterStackTest.this.ctx.sequence("filterOrder");
                ((Filter)this.one(ConfigurableFilterStackTest.this.f1)).doFilter((ServletRequest)this.with(5.same((Object)ConfigurableFilterStackTest.this.request)), (ServletResponse)this.with(5.same((Object)ConfigurableFilterStackTest.this.response)), (FilterChain)this.with(5.any(FilterChain.class)));
                this.will(MockUtils.continueFilterChain());
                this.inSequence(filterOrder);
                ((Filter)this.one(ConfigurableFilterStackTest.this.f2)).doFilter((ServletRequest)this.with(5.same((Object)ConfigurableFilterStackTest.this.request)), (ServletResponse)this.with(5.same((Object)ConfigurableFilterStackTest.this.response)), (FilterChain)this.with(5.any(FilterChain.class)));
                this.will(5.doAll((Action[])new Action[]{MockUtils.setAttribute("filter2started", "value"), MockUtils.continueFilterChain(), MockUtils.setAttribute("filter2finished", "value")}));
                this.inSequence(filterOrder);
                ((Filter)this.one(ConfigurableFilterStackTest.this.f3)).doFilter((ServletRequest)this.with(5.same((Object)ConfigurableFilterStackTest.this.request)), (ServletResponse)this.with(5.same((Object)ConfigurableFilterStackTest.this.response)), (FilterChain)this.with(5.any(FilterChain.class)));
                this.will(5.doAll((Action[])new Action[]{MockUtils.checkAttribute("filter2started", true), MockUtils.checkAttribute("filter2finished", false), MockUtils.continueFilterChain()}));
                this.inSequence(filterOrder);
            }
        });
    }
}

