/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.tags;

import freemarker.ext.beans.StringModel;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;
import org.springframework.util.StringUtils;

public final class DateTimeFormatTag
extends TagSupport
implements TemplateMethodModelEx {
    private static final long serialVersionUID = 4876809538088164519L;
    private Temporal value;
    private String pattern;

    public int doEndTag() throws JspException {
        String formatted = this.getFormattedDate();
        try {
            this.pageContext.getOut().print(formatted);
        }
        catch (IOException ioe) {
            throw new JspTagException(ioe.toString());
        }
        return 6;
    }

    public Object exec(List arguments) throws TemplateModelException {
        if (arguments.size() != 2) {
            throw new TemplateModelException((Exception)new IllegalArgumentException("Invalid number of arguments - should pass pattern, dateTime"));
        }
        if (!SimpleScalar.class.isAssignableFrom(arguments.get(0).getClass())) {
            throw new TemplateModelException((Exception)new IllegalArgumentException("Invalid argument - first argument should be a String pattern"));
        }
        String p = ((SimpleScalar)arguments.get(0)).getAsString();
        if (!StringModel.class.isAssignableFrom(arguments.get(1).getClass()) || !Temporal.class.isAssignableFrom(((StringModel)arguments.get(1)).getWrappedObject().getClass())) {
            throw new TemplateModelException((Exception)new IllegalArgumentException("Invalid argument - second argument should be a Temporal"));
        }
        Temporal v = (Temporal)((StringModel)arguments.get(1)).getWrappedObject();
        return this.getFormattedDate(p, v);
    }

    public String getFormattedDate() {
        return this.getFormattedDate(this.pattern, this.value);
    }

    public String getFormattedDate(String p, Temporal v) {
        if (!StringUtils.hasText((String)p) || v == null) {
            throw new IllegalArgumentException();
        }
        return DateTimeFormatter.ofPattern(p).format(v);
    }

    public void setValue(Temporal value) {
        this.value = value;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }
}

