/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.filter.stack.spring;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import uk.ac.warwick.util.core.StringUtils;
import uk.ac.warwick.util.web.filter.stack.ConfigurableFilterStack;
import uk.ac.warwick.util.web.filter.stack.FilterStackSet;

public final class FilterStackDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String EXCLUDED_URL_PATTERN_ELEMENT = "excluded-url-pattern";
    private static final String URL_PATTERN_ELEMENT = "url-pattern";
    private static final String FILTER_ELEMENT = "filter";
    private static final String MAPPING_ELEMENT = "mapping";

    protected AbstractBeanDefinition parseInternal(Element rootElement, ParserContext parserContext) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.genericBeanDefinition(ConfigurableFilterStack.class);
        if (rootElement.hasAttribute("abstract") && "true".equals(rootElement.getAttribute("abstract"))) {
            factory.setAbstract(true);
        }
        if (rootElement.hasAttribute("parent")) {
            factory.setParentName(rootElement.getAttribute("parent"));
        }
        ManagedList sets = new ManagedList();
        sets.setMergeEnabled(parserContext.getDelegate().parseMergeAttribute(rootElement));
        for (Element element : this.getChildElementsByTagName(rootElement, MAPPING_ELEMENT)) {
            AbstractBeanDefinition stackSet = this.handleMappingElement(element, parserContext);
            sets.add((Object)stackSet);
        }
        factory.addConstructorArgValue((Object)sets);
        return factory.getBeanDefinition();
    }

    private AbstractBeanDefinition handleMappingElement(Element mappingElement, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(FilterStackSet.class);
        ManagedList filters = new ManagedList();
        for (Element element : this.getChildElementsByTagName(mappingElement, FILTER_ELEMENT)) {
            filters.add((Object)new RuntimeBeanReference(this.getFilterName(element)));
        }
        ArrayList<String> includedPatterns = new ArrayList<String>();
        for (Element element : this.getChildElementsByTagName(mappingElement, URL_PATTERN_ELEMENT)) {
            includedPatterns.add(element.getTextContent());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Element element : this.getChildElementsByTagName(mappingElement, EXCLUDED_URL_PATTERN_ELEMENT)) {
            arrayList.add(element.getTextContent());
        }
        String string = mappingElement.getAttribute("name");
        builder.addConstructorArgValue((Object)filters);
        builder.addConstructorArgValue(includedPatterns);
        builder.addConstructorArgValue(arrayList);
        builder.addConstructorArgValue((Object)string);
        return builder.getBeanDefinition();
    }

    private String getFilterName(Element filterElement) {
        String attribute = filterElement.getAttribute("ref");
        String name = null;
        if (StringUtils.hasText((String)attribute)) {
            name = attribute;
        } else {
            Element element = DomUtils.getChildElementByTagName((Element)filterElement, (String)"ref");
            String bean = element.getAttribute("bean");
            String local = element.getAttribute("local");
            if (StringUtils.hasText((String)bean)) {
                name = bean;
            } else if (StringUtils.hasText((String)local)) {
                name = local;
            }
        }
        return name;
    }

    private List<Element> getChildElementsByTagName(Element parent, String name) {
        return DomUtils.getChildElementsByTagName((Element)parent, (String)name);
    }
}

