/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.filter.stack;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import uk.ac.warwick.util.web.filter.stack.NestedFilterChain;

public final class CompositeFilter
implements Filter {
    private final ImmutableList<Filter> filters;

    public CompositeFilter(List<Filter> input, boolean unwrap) {
        if (unwrap) {
            ImmutableList.Builder result = ImmutableList.builder();
            for (Filter f : input) {
                if (f instanceof CompositeFilter) {
                    result.addAll(((CompositeFilter)f).getFilters());
                    continue;
                }
                result.add((Object)f);
            }
            this.filters = result.build();
        } else {
            this.filters = input instanceof ImmutableList ? (ImmutableList)input : ImmutableList.copyOf(input);
        }
    }

    public CompositeFilter(List<Filter> input) {
        this(input, true);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain filterChain) throws IOException, ServletException {
        NestedFilterChain chain = new NestedFilterChain((List<Filter>)this.filters, filterChain);
        chain.doFilter(req, res);
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void init(FilterConfig config) throws ServletException {
        for (Filter filter : this.filters) {
            filter.init(config);
        }
    }

    public void destroy() {
        for (Filter filter : this.filters) {
            filter.destroy();
        }
    }
}

