/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.filter;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.util.web.filter.InetAddressRange;
import uk.ac.warwick.util.web.filter.RequestIPAddressHolder;

public final class RequestIPAddressHolderImpl
implements RequestIPAddressHolder {
    public static final Logger LOGGER = LoggerFactory.getLogger(RequestIPAddressHolderImpl.class);
    public static final Pattern IP_ADDRESS_PATTERN = Pattern.compile("[0-9]{1,3}(:?\\.[0-9]{1,3}){3}");
    private static final String X_FORWARDED_FOR_HEADER = "X-Forwarded-For";
    private final String ip;
    private boolean gotNonLocalAddress = true;

    public RequestIPAddressHolderImpl(HttpServletRequest request, Collection<String> localAddresses) {
        String xForwardedFor = request.getHeader(X_FORWARDED_FOR_HEADER);
        if (xForwardedFor != null) {
            String[] addresses = xForwardedFor.split(",");
            for (int i = 0; i < addresses.length; ++i) {
                String address = addresses[i].trim();
                if (!IP_ADDRESS_PATTERN.matcher(address).matches() || !this.isNonLocalAddress(localAddresses, address)) continue;
                this.ip = address;
                return;
            }
        }
        this.ip = request.getRemoteAddr();
        if (!this.isNonLocalAddress(localAddresses, this.ip)) {
            this.gotNonLocalAddress = false;
            LOGGER.warn("Couldn't resolve a non-local address from XFF " + xForwardedFor + " and remoteAddr " + this.ip);
        }
    }

    private boolean isNonLocalAddress(Collection<String> localAddresses, String address) {
        boolean local = false;
        if (localAddresses.contains(address)) {
            local = true;
        } else {
            try {
                InetAddress inetAddress = InetAddress.getByName(address);
                InetAddressRange private172 = InetAddressRange.of("172.16.0.0", "172.31.255.255");
                InetAddressRange hotspots = InetAddressRange.of("172.31.0.0", "172.31.255.255");
                InetAddressRange resnet = InetAddressRange.of("172.26.0.0", "172.29.255.255");
                InetAddressRange vpn = InetAddressRange.of("172.20.240.0", "172.20.255.255");
                if ("127.0.0.1".equals(address) || address.startsWith("192.168") || address.startsWith("169.254")) {
                    local = true;
                } else if (private172.contains(inetAddress) && !hotspots.contains(inetAddress) && !resnet.contains(inetAddress) && !vpn.contains(inetAddress)) {
                    local = true;
                }
            }
            catch (UnknownHostException e) {
                LOGGER.error("Failed to parse IP addresses! (this is a bug)", (Throwable)e);
            }
        }
        return !local;
    }

    @Override
    public boolean hasNonLocalAddress() {
        return this.gotNonLocalAddress;
    }

    @Override
    public String getNonLocalAddress() {
        return this.ip;
    }
}

