/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.filter;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Comparator;

public final class InetAddressRange {
    private static final InetAddressComparator COMPARATOR = new InetAddressComparator();
    private final InetAddress from;
    private final InetAddress to;

    public static InetAddressRange of(String fromIp, String toIp) throws UnknownHostException {
        return new InetAddressRange(InetAddress.getByName(fromIp), InetAddress.getByName(toIp));
    }

    public InetAddressRange(InetAddress from, InetAddress to) {
        this.from = from;
        this.to = to;
        if (COMPARATOR.compare(from, to) > 0) {
            throw new IllegalArgumentException("From address should be below the to address");
        }
    }

    public boolean contains(InetAddress addr) {
        return COMPARATOR.compare(this.from, addr) <= 0 && COMPARATOR.compare(addr, this.to) <= 0;
    }

    public String toString() {
        return this.from.getHostAddress() + "-" + this.to.getHostAddress();
    }

    static class InetAddressComparator
    implements Comparator<InetAddress> {
        InetAddressComparator() {
        }

        @Override
        public int compare(InetAddress adr1, InetAddress adr2) {
            byte[] ba2;
            byte[] ba1 = adr1.getAddress();
            if (ba1.length < (ba2 = adr2.getAddress()).length) {
                return -1;
            }
            if (ba1.length > ba2.length) {
                return 1;
            }
            for (int i = 0; i < ba1.length; ++i) {
                int b2;
                int b1 = this.unsignedByteToInt(ba1[i]);
                if (b1 == (b2 = this.unsignedByteToInt(ba2[i]))) continue;
                if (b1 < b2) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }

        private int unsignedByteToInt(byte b) {
            return b & 0xFF;
        }
    }
}

