/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web;

import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import org.apache.commons.codec.net.URLCodec;
import uk.ac.warwick.util.collections.Pair;
import uk.ac.warwick.util.core.StringUtils;
import uk.ac.warwick.util.web.DefaultUriParser;
import uk.ac.warwick.util.web.Uri;

public class EscapingUriParser
extends DefaultUriParser {
    private static final long serialVersionUID = 9212871455426260200L;
    private static final BitSet ALLOWED_QUERYSTRING_CHARACTERS;
    private static final BitSet ALLOWED_PATH_CHARACTERS;
    private static final long L_DIGIT;
    private static final long L_HEX;
    private static final long H_HEX;

    @Override
    public Uri parse(String text) {
        return super.parse(EscapingUriParser.escape(text));
    }

    private static Pair<String, String> splitPath(String path) {
        int indexOfPath = -1;
        for (int i = 0; i < 3 && (indexOfPath = path.indexOf(47, indexOfPath + 1)) != -1; ++i) {
        }
        if (indexOfPath == -1) {
            return null;
        }
        return Pair.of((Object)path.substring(0, indexOfPath), (Object)path.substring(indexOfPath));
    }

    private static String escape(String text) {
        try {
            if (StringUtils.hasText((String)text)) {
                Pair<String, String> splitPath;
                String path = text = text.trim();
                String query = "";
                String fragment = "";
                if (text.indexOf("?") != -1) {
                    path = text.substring(0, text.indexOf("?"));
                    query = text.substring(text.indexOf("?"));
                    if (query.indexOf("#") != -1) {
                        fragment = query.substring(query.indexOf("#"));
                        query = query.substring(0, query.indexOf("#"));
                    }
                } else if (text.indexOf("#") != -1) {
                    path = text.substring(0, text.indexOf("#"));
                    fragment = text.substring(text.indexOf("#"));
                }
                if ((splitPath = EscapingUriParser.splitPath(path)) != null) {
                    path = (String)splitPath.getLeft() + EscapingUriParser.scanEscapes((String)splitPath.getRight());
                }
                text = new String(URLCodec.encodeUrl((BitSet)ALLOWED_PATH_CHARACTERS, (byte[])path.getBytes("UTF-8")), "UTF-8");
                if (StringUtils.hasText((String)query)) {
                    query = new String(URLCodec.encodeUrl((BitSet)ALLOWED_QUERYSTRING_CHARACTERS, (byte[])query.getBytes("UTF-8")), "UTF-8");
                    query = EscapingUriParser.scanEscapes(query);
                    text = text + query;
                }
                if (StringUtils.hasText((String)fragment)) {
                    fragment = new String(URLCodec.encodeUrl((BitSet)ALLOWED_QUERYSTRING_CHARACTERS, (byte[])fragment.substring(1).getBytes("UTF-8")), "UTF-8");
                    fragment = "#" + EscapingUriParser.scanEscapes(fragment);
                    text = text + fragment;
                }
            }
            return text;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String scanEscapes(String query) {
        if (query.indexOf("%") == -1) {
            return query;
        }
        StringBuilder sb = new StringBuilder(query.length());
        for (int i = 0; i < query.length(); ++i) {
            char c = query.charAt(i);
            if (c == '%') {
                if (i + 3 <= query.length() && EscapingUriParser.match(query.charAt(i + 1), L_HEX, H_HEX) && EscapingUriParser.match(query.charAt(i + 2), L_HEX, H_HEX)) {
                    sb.append(c);
                    continue;
                }
                sb.append("%25");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static long lowMask(char first, char last) {
        long m = 0L;
        int f = Math.max(Math.min(first, 63), 0);
        int l = Math.max(Math.min(last, 63), 0);
        for (int i = f; i <= l; ++i) {
            m |= 1L << i;
        }
        return m;
    }

    private static long highMask(char first, char last) {
        long m = 0L;
        int f = Math.max(Math.min(first, 127), 64) - 64;
        int l = Math.max(Math.min(last, 127), 64) - 64;
        for (int i = f; i <= l; ++i) {
            m |= 1L << i;
        }
        return m;
    }

    private static boolean match(char c, long lowMask, long highMask) {
        if (c < '@') {
            return (1L << c & lowMask) != 0L;
        }
        if (c < '\u0080') {
            return (1L << c - 64 & highMask) != 0L;
        }
        return false;
    }

    static {
        int i;
        ALLOWED_QUERYSTRING_CHARACTERS = new BitSet(256);
        ALLOWED_QUERYSTRING_CHARACTERS.set(59);
        ALLOWED_QUERYSTRING_CHARACTERS.set(47);
        ALLOWED_QUERYSTRING_CHARACTERS.set(63);
        ALLOWED_QUERYSTRING_CHARACTERS.set(58);
        ALLOWED_QUERYSTRING_CHARACTERS.set(64);
        ALLOWED_QUERYSTRING_CHARACTERS.set(38);
        ALLOWED_QUERYSTRING_CHARACTERS.set(61);
        ALLOWED_QUERYSTRING_CHARACTERS.set(43);
        ALLOWED_QUERYSTRING_CHARACTERS.set(36);
        ALLOWED_QUERYSTRING_CHARACTERS.set(44);
        ALLOWED_QUERYSTRING_CHARACTERS.set(45);
        ALLOWED_QUERYSTRING_CHARACTERS.set(95);
        ALLOWED_QUERYSTRING_CHARACTERS.set(46);
        ALLOWED_QUERYSTRING_CHARACTERS.set(33);
        ALLOWED_QUERYSTRING_CHARACTERS.set(126);
        ALLOWED_QUERYSTRING_CHARACTERS.set(42);
        ALLOWED_QUERYSTRING_CHARACTERS.set(39);
        ALLOWED_QUERYSTRING_CHARACTERS.set(40);
        ALLOWED_QUERYSTRING_CHARACTERS.set(41);
        ALLOWED_QUERYSTRING_CHARACTERS.set(37);
        for (i = 97; i <= 122; ++i) {
            ALLOWED_QUERYSTRING_CHARACTERS.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            ALLOWED_QUERYSTRING_CHARACTERS.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            ALLOWED_QUERYSTRING_CHARACTERS.set(i);
        }
        ALLOWED_PATH_CHARACTERS = new BitSet(256);
        ALLOWED_PATH_CHARACTERS.set(59);
        ALLOWED_PATH_CHARACTERS.set(47);
        ALLOWED_PATH_CHARACTERS.set(63);
        ALLOWED_PATH_CHARACTERS.set(58);
        ALLOWED_PATH_CHARACTERS.set(64);
        ALLOWED_PATH_CHARACTERS.set(38);
        ALLOWED_PATH_CHARACTERS.set(61);
        ALLOWED_PATH_CHARACTERS.set(43);
        ALLOWED_PATH_CHARACTERS.set(36);
        ALLOWED_PATH_CHARACTERS.set(44);
        ALLOWED_PATH_CHARACTERS.set(45);
        ALLOWED_PATH_CHARACTERS.set(95);
        ALLOWED_PATH_CHARACTERS.set(46);
        ALLOWED_PATH_CHARACTERS.set(33);
        ALLOWED_PATH_CHARACTERS.set(126);
        ALLOWED_PATH_CHARACTERS.set(42);
        ALLOWED_PATH_CHARACTERS.set(39);
        ALLOWED_PATH_CHARACTERS.set(40);
        ALLOWED_PATH_CHARACTERS.set(41);
        ALLOWED_PATH_CHARACTERS.set(37);
        for (i = 97; i <= 122; ++i) {
            ALLOWED_PATH_CHARACTERS.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            ALLOWED_PATH_CHARACTERS.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            ALLOWED_PATH_CHARACTERS.set(i);
        }
        L_HEX = L_DIGIT = EscapingUriParser.lowMask('0', '9');
        H_HEX = EscapingUriParser.highMask('A', 'F') | EscapingUriParser.highMask('a', 'f');
    }
}

