/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.spring.validator;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import uk.ac.warwick.util.web.spring.validator.AbstractValidator;

public abstract class AbstractValidatorTest<T, V extends AbstractValidator<T>> {
    private V validator;

    protected abstract T createTarget();

    protected abstract V createValidator() throws InstantiationException, IllegalAccessException;

    @Before
    public void setUp() throws InstantiationException, IllegalAccessException {
        this.validator = this.createValidator();
    }

    @Test
    public void supportsClass() {
        T command = this.createTarget();
        Assert.assertTrue((boolean)this.validator.supports(command.getClass()));
    }

    @Test
    public void doesntSupportAllClasses() {
        Assert.assertFalse((boolean)this.validator.supports(Object.class));
    }

    public Errors getErrors(T command) {
        BindException errors = new BindException(command, "command");
        this.validator.validate(command, (Errors)errors);
        return errors;
    }

    public void assertPasses(T command) {
        Errors errors = this.getErrors(command);
        Assert.assertFalse((String)("Expected validation to pass: " + errors.toString()), (boolean)errors.hasErrors());
    }

    public Errors assertFails(T command) {
        Errors errors = this.getErrors(command);
        Assert.assertTrue((String)"Expected validation to fail", (boolean)errors.hasErrors());
        return errors;
    }

    protected V getValidator() {
        return this.validator;
    }
}

