/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.web.Uri;
import uk.ac.warwick.util.web.UriBuilder;

public class UriBuilderBuildingTest {
    @Test
    public void replacingQuery() throws Exception {
        Uri url = Uri.parse((String)"http://www.example.com/fac/soc?view=daily");
        UriBuilder builder = new UriBuilder(url);
        builder.addQueryParameter("page", "/fog").addQueryParameter("escapedText", "http://x");
        Uri newUrl = builder.toUri();
        Assert.assertEquals((Object)"http://www.example.com/fac/soc?view=daily&page=%2Ffog&escapedText=http%3A%2F%2Fx", (Object)newUrl.toString());
    }

    @Test
    public void replacingQueryWithTrailingSlash() throws Exception {
        Uri url = Uri.parse((String)"http://www.example.com/fac/soc/?view=daily");
        UriBuilder builder = new UriBuilder(url);
        builder.addQueryParameter("page", "/fog").addQueryParameter("escapedText", "http://x");
        Uri newUrl = builder.toUri();
        Assert.assertEquals((Object)"http://www.example.com/fac/soc/?view=daily&page=%2Ffog&escapedText=http%3A%2F%2Fx", (Object)newUrl.toString());
    }

    @Test
    public void replacingQueryWithNoPath() throws Exception {
        Uri url = Uri.parse((String)"http://www.example.com?view=daily");
        UriBuilder builder = new UriBuilder(url);
        builder.addQueryParameter("page", "/fog").addQueryParameter("escapedText", "http://x");
        Uri newUrl = builder.toUri();
        Assert.assertEquals((Object)"http://www.example.com?view=daily&page=%2Ffog&escapedText=http%3A%2F%2Fx", (Object)newUrl.toString());
    }

    @Test
    public void replacingQueryWithNoPathWithSlash() throws Exception {
        Uri url = Uri.parse((String)"http://www.example.com/?view=daily");
        UriBuilder builder = new UriBuilder(url);
        builder.addQueryParameter("page", "/fog").addQueryParameter("escapedText", "http://x");
        Uri newUrl = builder.toUri();
        Assert.assertEquals((Object)"http://www.example.com/?view=daily&page=%2Ffog&escapedText=http%3A%2F%2Fx", (Object)newUrl.toString());
    }
}

