/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.virusscan.http;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.Future;
import javax.annotation.PreDestroy;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.nio.client.HttpAsyncClient;
import uk.ac.warwick.util.virusscan.http.AsyncHttpClient;

@Named
@Singleton
public class AsyncHttpClientImpl
implements AsyncHttpClient {
    private final CloseableHttpAsyncClient httpClient = HttpAsyncClients.custom().setDefaultConnectionConfig(ConnectionConfig.custom().setBufferSize(8192).setCharset(StandardCharsets.UTF_8).build()).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(300000).setExpectContinueEnabled(true).setRedirectsEnabled(false).build()).setMaxConnPerRoute(5).build();

    public AsyncHttpClientImpl() {
        this.start();
    }

    @Override
    public void start() {
        this.httpClient.start();
    }

    @Override
    @PreDestroy
    public void destroy() throws Exception {
        this.httpClient.close();
    }

    @Override
    public boolean isRunning() {
        return this.httpClient.isRunning();
    }

    @Override
    public Future<HttpResponse> execute(HttpUriRequest request, FutureCallback<HttpResponse> callback) {
        return this.httpClient.execute(request, callback);
    }

    public HttpAsyncClient get() {
        return this.httpClient;
    }
}

