/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.virusscan.http;

import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.warwick.util.AbstractJUnit4JettyTest;
import uk.ac.warwick.util.virusscan.VirusScanResult;
import uk.ac.warwick.util.virusscan.VirusScanServiceStatus;
import uk.ac.warwick.util.virusscan.conf.Configuration;
import uk.ac.warwick.util.virusscan.http.AsyncHttpClient;
import uk.ac.warwick.util.virusscan.http.AsyncHttpClientImpl;
import uk.ac.warwick.util.virusscan.http.HttpVirusScanService;

public class HttpVirusScanServiceTest
extends AbstractJUnit4JettyTest {
    private static final byte[] CLEAN_INPUT = "clean".getBytes(StandardCharsets.UTF_8);
    private static final byte[] VIRUS_INPUT = "virus".getBytes(StandardCharsets.UTF_8);
    private static final byte[] ERROR_INPUT = "error".getBytes(StandardCharsets.UTF_8);
    private static final String EXPECTED_API_KEY = "expected";
    private static final String BACKEND_DOWN_API_KEY = "backend-down";
    private static final String UNAVAILABLE_API_KEY = "unavailable";
    private MutableConfiguration configuration = new MutableConfiguration();
    private HttpVirusScanService service = new HttpVirusScanService((AsyncHttpClient)new AsyncHttpClientImpl(), (Configuration)this.configuration);

    @BeforeClass
    public static void setupServlets() throws Exception {
        HttpVirusScanServiceTest.startServer((Map)new HashMap<String, String>(){
            {
                this.put("/scan", ScanServlet.class.getName());
                this.put("/service/healthcheck", HealthcheckServlet.class.getName());
            }
        });
    }

    @Before
    public void setup() throws Exception {
        this.configuration.setApiHost(this.serverAddress.replaceFirst("\\/$", ""));
        this.configuration.setApiKey(EXPECTED_API_KEY);
    }

    @Test(timeout=1000L)
    public void scanClean() throws Exception {
        ByteSource input = ByteSource.wrap((byte[])CLEAN_INPUT);
        VirusScanResult result = (VirusScanResult)this.service.scan(input).get();
        Assert.assertEquals((Object)VirusScanResult.Status.clean, (Object)result.getStatus());
        Assert.assertFalse((boolean)result.getError().isPresent());
        Assert.assertFalse((boolean)result.getVirus().isPresent());
    }

    @Test(timeout=1000L)
    public void scanVirus() throws Exception {
        ByteSource input = ByteSource.wrap((byte[])VIRUS_INPUT);
        VirusScanResult result = (VirusScanResult)this.service.scan(input).get();
        Assert.assertEquals((Object)VirusScanResult.Status.virus, (Object)result.getStatus());
        Assert.assertFalse((boolean)result.getError().isPresent());
        Assert.assertTrue((boolean)result.getVirus().isPresent());
        Assert.assertEquals((Object)"Cyrus", result.getVirus().get());
    }

    @Test(timeout=1000L)
    public void scanError() throws Exception {
        ByteSource input = ByteSource.wrap((byte[])ERROR_INPUT);
        VirusScanResult result = (VirusScanResult)this.service.scan(input).get();
        Assert.assertEquals((Object)VirusScanResult.Status.error, (Object)result.getStatus());
        Assert.assertTrue((boolean)result.getError().isPresent());
        Assert.assertEquals((Object)"There was a problem checking the input", result.getError().get());
        Assert.assertFalse((boolean)result.getVirus().isPresent());
    }

    @Test(timeout=1000L)
    public void scanBackendDown() throws Exception {
        this.configuration.setApiKey(BACKEND_DOWN_API_KEY);
        ByteSource input = ByteSource.wrap((byte[])CLEAN_INPUT);
        VirusScanResult result = (VirusScanResult)this.service.scan(input).get();
        Assert.assertEquals((Object)VirusScanResult.Status.error, (Object)result.getStatus());
        Assert.assertTrue((boolean)result.getError().isPresent());
        Assert.assertEquals((Object)"Error connecting to ClamAV service", result.getError().get());
        Assert.assertFalse((boolean)result.getVirus().isPresent());
    }

    @Test(timeout=1000L, expected=ExecutionException.class)
    public void scanUnavailable() throws Exception {
        this.configuration.setApiKey(UNAVAILABLE_API_KEY);
        ByteSource input = ByteSource.wrap((byte[])CLEAN_INPUT);
        this.service.scan(input).get();
    }

    @Test(timeout=1000L)
    public void statusAvailable() throws Exception {
        VirusScanServiceStatus status = (VirusScanServiceStatus)this.service.status().get();
        Assert.assertTrue((boolean)status.isAvailable());
        Assert.assertEquals((Object)"ClamAV available", (Object)status.getStatusMessage());
    }

    @Test(timeout=1000L)
    public void statusBackendDown() throws Exception {
        this.configuration.setApiKey(BACKEND_DOWN_API_KEY);
        VirusScanServiceStatus status = (VirusScanServiceStatus)this.service.status().get();
        Assert.assertFalse((boolean)status.isAvailable());
        Assert.assertEquals((Object)"Error connecting to ClamAV service", (Object)status.getStatusMessage());
    }

    @Test(timeout=1000L)
    public void statusUnavailable() throws Exception {
        this.configuration.setApiKey(UNAVAILABLE_API_KEY);
        VirusScanServiceStatus status = (VirusScanServiceStatus)this.service.status().get();
        Assert.assertFalse((boolean)status.isAvailable());
        Assert.assertEquals((Object)"Error connecting to virus scan service", (Object)status.getStatusMessage());
    }

    private static class MutableConfiguration
    implements Configuration {
        private String apiHost;
        private String apiKey;

        private MutableConfiguration() {
        }

        public String getApiHost() {
            return this.apiHost;
        }

        public void setApiHost(String apiHost) {
            this.apiHost = apiHost;
        }

        public String getApiKey() {
            return this.apiKey;
        }

        public boolean isEnabled() {
            return true;
        }

        public void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }
    }

    public static class HealthcheckServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            String apiKey = req.getHeader("Authorization");
            Assert.assertTrue((boolean)apiKey.toLowerCase().startsWith("api-key "));
            apiKey = apiKey.substring(8);
            if (apiKey.equals(HttpVirusScanServiceTest.EXPECTED_API_KEY)) {
                resp.setStatus(200);
                resp.getWriter().write("{\"data\":[{\"name\":\"clamav\",\"status\":\"okay\",\"message\":\"ClamAV available\",\"testedAt\":\"2017-03-16T17:11:12.005Z\"}]}");
            } else if (apiKey.equals(HttpVirusScanServiceTest.BACKEND_DOWN_API_KEY)) {
                resp.setStatus(200);
                resp.getWriter().write("{\"data\":[{\"name\":\"clamav\",\"status\":\"error\",\"message\":\"Error connecting to ClamAV service\",\"testedAt\":\"2017-03-16T17:11:12.005Z\"}]}");
            } else if (apiKey.equals(HttpVirusScanServiceTest.UNAVAILABLE_API_KEY)) {
                resp.setStatus(503);
            }
        }
    }

    public static class ScanServlet
    extends HttpServlet {
        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            String apiKey = req.getHeader("Authorization");
            Assert.assertTrue((boolean)apiKey.toLowerCase().startsWith("api-key "));
            apiKey = apiKey.substring(8);
            if (apiKey.equals(HttpVirusScanServiceTest.EXPECTED_API_KEY)) {
                byte[] input = ByteStreams.toByteArray((InputStream)req.getInputStream());
                if (Arrays.equals(input, CLEAN_INPUT)) {
                    resp.setStatus(200);
                    resp.getWriter().write("{\"status\":\"clean\"}");
                } else if (Arrays.equals(input, VIRUS_INPUT)) {
                    resp.setStatus(400);
                    resp.getWriter().write("{\"status\":\"virus\",\"virus\":\"Cyrus\"}");
                } else if (Arrays.equals(input, ERROR_INPUT)) {
                    resp.setStatus(500);
                    resp.getWriter().write("{\"status\":\"error\",\"error\":\"There was a problem checking the input\"}");
                }
            } else if (apiKey.equals(HttpVirusScanServiceTest.BACKEND_DOWN_API_KEY)) {
                resp.setStatus(500);
                resp.getWriter().write("{\"status\":\"error\",\"error\":\"Error connecting to ClamAV service\"}");
            } else if (apiKey.equals(HttpVirusScanServiceTest.UNAVAILABLE_API_KEY)) {
                resp.setStatus(503);
            }
        }
    }
}

