/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.virusscan.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.util.virusscan.VirusScanResult;
import uk.ac.warwick.util.virusscan.VirusScanService;
import uk.ac.warwick.util.virusscan.VirusScanServiceStatus;
import uk.ac.warwick.util.virusscan.conf.Configuration;
import uk.ac.warwick.util.virusscan.http.AsyncHttpClient;

@Named(value="virusScanService")
@Singleton
public class HttpVirusScanService
implements VirusScanService {
    private final Logger LOGGER = LoggerFactory.getLogger(HttpVirusScanService.class);
    private final AsyncHttpClient asyncHttpClient;
    private final Configuration configuration;
    private final ObjectMapper mapper = new ObjectMapper();

    @Inject
    public HttpVirusScanService(AsyncHttpClient asyncHttpClient, Configuration configuration) {
        this.asyncHttpClient = asyncHttpClient;
        this.configuration = configuration;
    }

    @PostConstruct
    public void init() {
        this.asyncHttpClient.start();
    }

    @Override
    public CompletableFuture<VirusScanResult> scan(ByteSource in) throws IOException {
        if (!this.configuration.isEnabled()) {
            this.LOGGER.warn("Virus scans are disabled");
            return CompletableFuture.completedFuture(new VirusScanResult(){

                @Override
                public VirusScanResult.Status getStatus() {
                    return VirusScanResult.Status.clean;
                }

                @Override
                public Optional<String> getVirus() {
                    return Optional.empty();
                }

                @Override
                public Optional<String> getError() {
                    return Optional.empty();
                }
            });
        }
        HttpPost request = this.prepare(new HttpPost(this.configuration.getApiHost() + "/scan"));
        request.setEntity(EntityBuilder.create().setStream(in.openStream()).build());
        final CompletableFuture<VirusScanResult> result = new CompletableFuture<VirusScanResult>();
        this.asyncHttpClient.execute((HttpUriRequest)request, new FutureCallback<HttpResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(HttpResponse response) {
                HttpEntity entity = response.getEntity();
                try {
                    result.complete(HttpVirusScanService.this.mapper.readValue(entity.getContent(), HttpVirusScanResult.class));
                }
                catch (IOException e) {
                    result.completeExceptionally(e);
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)entity);
                }
            }

            public void failed(Exception ex) {
                result.completeExceptionally(ex);
            }

            public void cancelled() {
                result.cancel(true);
            }
        });
        return result;
    }

    @Override
    public CompletableFuture<VirusScanServiceStatus> status() {
        HttpGet request = this.prepare(new HttpGet(this.configuration.getApiHost() + "/service/healthcheck"));
        final CompletableFuture<VirusScanServiceStatus> result = new CompletableFuture<VirusScanServiceStatus>();
        this.asyncHttpClient.execute((HttpUriRequest)request, new FutureCallback<HttpResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(HttpResponse response) {
                HttpEntity entity = response.getEntity();
                try {
                    if (response.getStatusLine().getStatusCode() == 200) {
                        Map healthchecks = (Map)HttpVirusScanService.this.mapper.readValue(entity.getContent(), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                        Map healthcheck = (Map)((List)healthchecks.get("data")).iterator().next();
                        boolean isAvailable = "okay".equals(healthcheck.get("status"));
                        String statusMessage = healthcheck.get("message").toString();
                        result.complete(new HttpVirusScanServiceStatus(isAvailable, statusMessage));
                    } else {
                        result.complete(new HttpVirusScanServiceStatus(false, "Error connecting to virus scan service"));
                    }
                }
                catch (Throwable e) {
                    result.completeExceptionally(e);
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)entity);
                }
            }

            public void failed(Exception ex) {
                result.completeExceptionally(ex);
            }

            public void cancelled() {
                result.cancel(true);
            }
        });
        return result;
    }

    private <T extends HttpUriRequest> T prepare(T request) {
        request.setHeader("Authorization", "Api-Key " + this.configuration.getApiKey());
        request.setHeader("User-Agent", "WarwickUtils HttpVirusScanService");
        return request;
    }

    private static class HttpVirusScanServiceStatus
    implements VirusScanServiceStatus {
        private final boolean available;
        private final String statusMessage;

        private HttpVirusScanServiceStatus(boolean available, String statusMessage) {
            this.available = available;
            this.statusMessage = statusMessage;
        }

        @Override
        public boolean isAvailable() {
            return this.available;
        }

        @Override
        public String getStatusMessage() {
            return this.statusMessage;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("available", this.available).append("statusMessage", (Object)this.statusMessage).toString();
        }
    }

    private static class HttpVirusScanResult
    implements VirusScanResult {
        private VirusScanResult.Status status;
        private Optional<String> virus = Optional.empty();
        private Optional<String> error = Optional.empty();

        private HttpVirusScanResult() {
        }

        @Override
        public VirusScanResult.Status getStatus() {
            return this.status;
        }

        public void setStatus(VirusScanResult.Status status) {
            this.status = status;
        }

        @Override
        public Optional<String> getVirus() {
            return this.virus;
        }

        public void setVirus(String virus) {
            this.virus = Optional.of(virus);
        }

        @Override
        public Optional<String> getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = Optional.of(error);
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("status", (Object)this.status).append("virus", this.virus).append("error", this.error).toString();
        }
    }
}

