/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.workingdays;

import java.io.IOException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.ac.warwick.util.workingdays.WorkingTimeHelperImpl;

public final class WorkingTimeHelperTest {
    private WorkingTimeHelperImpl instance;

    @Before
    public void instantiate() throws IOException {
        this.instance = new WorkingTimeHelperImpl();
    }

    @Test
    public void testSameWorkingPeriod() {
        OffsetDateTime start = ZonedDateTime.of(LocalDate.of(2025, 10, 16), LocalTime.of(10, 0), ZoneId.systemDefault()).toOffsetDateTime();
        OffsetDateTime end = ZonedDateTime.of(LocalDate.of(2025, 10, 16), LocalTime.of(16, 0), ZoneId.systemDefault()).toOffsetDateTime();
        Assert.assertEquals((Object)Duration.ofHours(6L), (Object)this.instance.getWorkingTimeBetween(start, end));
    }

    @Test
    public void testAlwaysPositive() {
        OffsetDateTime start = ZonedDateTime.of(LocalDate.of(2025, 10, 16), LocalTime.of(10, 0), ZoneId.systemDefault()).toOffsetDateTime();
        OffsetDateTime end = ZonedDateTime.of(LocalDate.of(2025, 10, 16), LocalTime.of(16, 0), ZoneId.systemDefault()).toOffsetDateTime();
        Assert.assertEquals((Object)Duration.ofHours(6L), (Object)this.instance.getWorkingTimeBetween(end, start));
    }

    @Test
    public void testZero() {
        OffsetDateTime start = ZonedDateTime.of(LocalDate.of(2025, 10, 16), LocalTime.of(10, 0), ZoneId.systemDefault()).toOffsetDateTime();
        Assert.assertEquals((Object)Duration.ZERO, (Object)this.instance.getWorkingTimeBetween(start, start));
    }

    @Test
    public void testSameDayStartWorking() {
        OffsetDateTime start = ZonedDateTime.of(LocalDate.of(2025, 10, 16), LocalTime.of(10, 15), ZoneId.systemDefault()).toOffsetDateTime();
        OffsetDateTime end = ZonedDateTime.of(LocalDate.of(2025, 10, 16), LocalTime.of(18, 30), ZoneId.systemDefault()).toOffsetDateTime();
        Assert.assertEquals((Object)Duration.ofHours(6L).plusMinutes(45L), (Object)this.instance.getWorkingTimeBetween(start, end));
    }

    @Test
    public void testSameDayStartNotWorking() {
        OffsetDateTime start = ZonedDateTime.of(LocalDate.of(2025, 10, 16), LocalTime.of(8, 45), ZoneId.systemDefault()).toOffsetDateTime();
        OffsetDateTime end = ZonedDateTime.of(LocalDate.of(2025, 10, 16), LocalTime.of(12, 30), ZoneId.systemDefault()).toOffsetDateTime();
        Assert.assertEquals((Object)Duration.ofHours(3L).plusMinutes(30L), (Object)this.instance.getWorkingTimeBetween(start, end));
    }

    @Test
    public void testOverTheWeekend() {
        OffsetDateTime start = ZonedDateTime.of(LocalDate.of(2025, 10, 17), LocalTime.of(16, 0), ZoneId.systemDefault()).toOffsetDateTime();
        OffsetDateTime end = ZonedDateTime.of(LocalDate.of(2025, 10, 20), LocalTime.of(10, 0), ZoneId.systemDefault()).toOffsetDateTime();
        Assert.assertEquals((Object)Duration.ofHours(2L), (Object)this.instance.getWorkingTimeBetween(start, end));
    }

    @Test
    public void testDuringTheWeekend() {
        OffsetDateTime start = ZonedDateTime.of(LocalDate.of(2025, 10, 18), LocalTime.of(16, 0), ZoneId.systemDefault()).toOffsetDateTime();
        OffsetDateTime end = ZonedDateTime.of(LocalDate.of(2025, 10, 19), LocalTime.of(10, 0), ZoneId.systemDefault()).toOffsetDateTime();
        Assert.assertEquals((Object)Duration.ZERO, (Object)this.instance.getWorkingTimeBetween(start, end));
    }

    @Test
    public void testXmasHoliday() {
        OffsetDateTime start = ZonedDateTime.of(LocalDate.of(2025, 12, 23), LocalTime.of(16, 0), ZoneId.systemDefault()).toOffsetDateTime();
        OffsetDateTime end = ZonedDateTime.of(LocalDate.of(2026, 1, 2), LocalTime.of(10, 0), ZoneId.systemDefault()).toOffsetDateTime();
        Assert.assertEquals((Object)Duration.ofHours(2L), (Object)this.instance.getWorkingTimeBetween(start, end));
    }

    @Test
    public void testPreciseTime() {
        OffsetDateTime start = ZonedDateTime.of(LocalDate.of(2025, 10, 17), LocalTime.of(10, 20, 30, 123), ZoneId.systemDefault()).toOffsetDateTime();
        OffsetDateTime end = ZonedDateTime.of(LocalDate.of(2025, 10, 20), LocalTime.of(10, 20, 30, 456), ZoneId.systemDefault()).toOffsetDateTime();
        Assert.assertEquals((Object)Duration.ofHours(8L).plusNanos(333L), (Object)this.instance.getWorkingTimeBetween(start, end));
    }
}

