/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.workingdays;

import java.time.LocalDate;
import java.time.Month;
import java.util.Iterator;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.workingdays.WorkingDaysHelperImpl;

public final class WorkingDaysHelperTest {
    @Test
    public void constructor() throws Exception {
        WorkingDaysHelperImpl bean = new WorkingDaysHelperImpl();
        Set holidayDates = bean.getHolidayDates();
        LocalDate xmas = LocalDate.of(2012, Month.DECEMBER, 25);
        Assert.assertTrue((boolean)holidayDates.contains(xmas));
        LocalDate mayDay = LocalDate.of(2013, Month.MAY, 6);
        Assert.assertTrue((boolean)holidayDates.contains(mayDay));
    }

    @Test
    public void testRange() throws Exception {
        WorkingDaysHelperImpl bean = new WorkingDaysHelperImpl();
        LocalDate start = LocalDate.of(2012, Month.DECEMBER, 1);
        LocalDate end = LocalDate.of(2013, Month.JANUARY, 31);
        Assert.assertEquals((long)37L, (long)bean.getNumWorkingDays(start, end));
        start = LocalDate.of(2013, Month.MAY, 1);
        end = LocalDate.of(2013, Month.MAY, 31);
        Assert.assertEquals((long)21L, (long)bean.getNumWorkingDays(start, end));
    }

    @Test
    public void testNegativeRange() throws Exception {
        WorkingDaysHelperImpl bean = new WorkingDaysHelperImpl();
        LocalDate end = LocalDate.of(2012, Month.DECEMBER, 1);
        LocalDate start = LocalDate.of(2013, Month.JANUARY, 31);
        Assert.assertEquals((long)-37L, (long)bean.getNumWorkingDays(start, end));
        end = LocalDate.of(2013, Month.MAY, 1);
        start = LocalDate.of(2013, Month.MAY, 31);
        Assert.assertEquals((long)-21L, (long)bean.getNumWorkingDays(start, end));
    }

    @Test
    public void addWorkingDays() throws Exception {
        WorkingDaysHelperImpl bean = new WorkingDaysHelperImpl();
        LocalDate start = LocalDate.of(2012, Month.DECEMBER, 10);
        Assert.assertEquals((Object)LocalDate.of(2013, Month.JANUARY, 16), (Object)bean.datePlusWorkingDays(start, 20));
    }

    @Test
    public void testHasFutureHolidays() throws Exception {
        WorkingDaysHelperImpl bean = new WorkingDaysHelperImpl();
        Set holidayDates = bean.getHolidayDates();
        LocalDate nextYear = LocalDate.now().plusMonths(4L);
        LocalDate newestFound = null;
        Iterator i = holidayDates.iterator();
        boolean result = false;
        while (!result && i.hasNext()) {
            LocalDate next = (LocalDate)i.next();
            if (newestFound == null || newestFound.isBefore(next)) {
                newestFound = next;
            }
            result = next.isAfter(nextYear);
        }
        if (!result) {
            Assert.fail((String)("No holiday dates found after 4 months. The newest date supplied is " + newestFound));
        }
    }
}

