/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.tags;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.StringModel;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.web.tags.DateTimeFormatTag;

public final class DateTimeFormatTagTest {
    @Test
    public void itWorksJSP() throws Exception {
        DateTimeFormatTag tag = new DateTimeFormatTag();
        tag.setPattern("EEEE, dd MMMM ''yy");
        tag.setValue((Temporal)LocalDateTime.of(2009, Month.JANUARY, 15, 15, 30, 15, 0));
        Assert.assertEquals((Object)"Thursday, 15 January '09", (Object)tag.getFormattedDate());
    }

    @Test(expected=IllegalArgumentException.class)
    public void throwsExceptionOnNoDateTimeJSP() throws Exception {
        DateTimeFormatTag tag = new DateTimeFormatTag();
        tag.setPattern("EEEE, dd MMMM ''yy");
        tag.doEndTag();
        Assert.fail((String)"Should have thrown exception");
    }

    @Test(expected=IllegalArgumentException.class)
    public void throwsExceptionOnNoFormatJSP() throws Exception {
        DateTimeFormatTag tag = new DateTimeFormatTag();
        tag.setValue((Temporal)LocalDateTime.of(2009, Month.JANUARY, 15, 15, 30, 15, 0));
        tag.doEndTag();
        Assert.fail((String)"Should have thrown exception");
    }

    @Test
    public void itWorksFreemarker() throws Exception {
        DateTimeFormatTag tag = new DateTimeFormatTag();
        StringModel model = new StringModel((Object)LocalDateTime.of(2009, Month.JANUARY, 15, 15, 30, 15, 0), BeansWrapper.getDefaultInstance());
        List<TemplateScalarModel> arguments = Arrays.asList(new SimpleScalar("EEEE, dd MMMM ''yy"), model);
        Assert.assertEquals((Object)"Thursday, 15 January '09", (Object)tag.exec(arguments));
    }

    @Test(expected=TemplateModelException.class)
    public void throwsExceptionOnNoDateTimeFreemarker() throws Exception {
        DateTimeFormatTag tag = new DateTimeFormatTag();
        tag.exec(Arrays.asList(new SimpleScalar("EEEE, dd MMMM ''yy")));
        Assert.fail((String)"Should have thrown exception");
    }

    @Test(expected=TemplateModelException.class)
    public void throwsExceptionOnNoFormatFreemarker() throws Exception {
        DateTimeFormatTag tag = new DateTimeFormatTag();
        StringModel model = new StringModel((Object)LocalDateTime.of(2009, Month.JANUARY, 15, 15, 30, 15, 0), BeansWrapper.getDefaultInstance());
        tag.exec(Arrays.asList(model));
        Assert.fail((String)"Should have thrown exception");
    }
}

