/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.bind;

import java.net.MalformedURLException;
import java.net.URL;
import junit.framework.TestCase;
import uk.ac.warwick.util.web.bind.UrlPropertyEditor;

public final class UrlPropertyEditorTest
extends TestCase {
    public void testSetAsTextWithValidUrl() throws MalformedURLException {
        String url = "http://google.co.uk";
        URL expectedUrl = new URL(url);
        UrlPropertyEditor editor = new UrlPropertyEditor();
        editor.setAsText(url);
        UrlPropertyEditorTest.assertEquals((Object)expectedUrl, (Object)editor.getValue());
    }

    public void testSetAsTextWithEmptyUrl() throws MalformedURLException {
        String url = "";
        UrlPropertyEditor editor = new UrlPropertyEditor();
        editor.setAsText(url);
        UrlPropertyEditorTest.assertNull((Object)editor.getValue());
    }

    public void testSetAsTextWithUnknownUrl() throws MalformedURLException {
        String url = "this shouldn't work";
        UrlPropertyEditor editor = new UrlPropertyEditor();
        try {
            editor.setAsText(url);
            UrlPropertyEditorTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetAsText() throws MalformedURLException {
        String url = "http://google.co.uk";
        UrlPropertyEditor editor = new UrlPropertyEditor();
        editor.setValue((Object)new URL(url));
        UrlPropertyEditorTest.assertEquals((String)"url", (String)url, (String)editor.getAsText());
    }

    public void testGetAsTextWithNullContent() {
        UrlPropertyEditor editor = new UrlPropertyEditor();
        editor.setValue(null);
        UrlPropertyEditorTest.assertNull((Object)editor.getAsText());
    }
}

