/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import uk.ac.warwick.util.web.Uri;
import uk.ac.warwick.util.web.UriBuilder;

public class UriTest {
    @Test
    public void parseFull() {
        Uri uri = Uri.parse((String)"http://apache.org/foo?a=b&a=c&b=d+e#blah");
        Assert.assertEquals((Object)"http", (Object)uri.getScheme());
        Assert.assertEquals((Object)"apache.org", (Object)uri.getAuthority());
        Assert.assertEquals((Object)"/foo", (Object)uri.getPath());
        Assert.assertEquals((Object)"a=b&a=c&b=d+e", (Object)uri.getQuery());
        List<String> params = Arrays.asList("b", "c");
        Assert.assertEquals(params, (Object)uri.getQueryParameters("a"));
        Assert.assertEquals((Object)"b", (Object)uri.getQueryParameter("a"));
        Assert.assertEquals((Object)"d e", (Object)uri.getQueryParameter("b"));
        Assert.assertEquals((Object)"blah", (Object)uri.getFragment());
        Assert.assertEquals((Object)"http://apache.org/foo?a=b&a=c&b=d+e#blah", (Object)uri.toString());
    }

    @Test
    public void parseNoScheme() {
        Uri uri = Uri.parse((String)"//apache.org/foo?a=b&a=c&b=d+e#blah");
        Assert.assertNull((Object)uri.getScheme());
        Assert.assertEquals((Object)"apache.org", (Object)uri.getAuthority());
        Assert.assertEquals((Object)"/foo", (Object)uri.getPath());
        Assert.assertEquals((Object)"a=b&a=c&b=d+e", (Object)uri.getQuery());
        List<String> params = Arrays.asList("b", "c");
        Assert.assertEquals(params, (Object)uri.getQueryParameters("a"));
        Assert.assertEquals((Object)"b", (Object)uri.getQueryParameter("a"));
        Assert.assertEquals((Object)"d e", (Object)uri.getQueryParameter("b"));
        Assert.assertEquals((Object)"blah", (Object)uri.getFragment());
    }

    @Test
    public void parseNoAuthority() {
        Uri uri = Uri.parse((String)"http:/foo?a=b&a=c&b=d+e#blah");
        Assert.assertEquals((Object)"http", (Object)uri.getScheme());
        Assert.assertNull((Object)uri.getAuthority());
        Assert.assertEquals((Object)"/foo", (Object)uri.getPath());
        Assert.assertEquals((Object)"a=b&a=c&b=d+e", (Object)uri.getQuery());
        List<String> params = Arrays.asList("b", "c");
        Assert.assertEquals(params, (Object)uri.getQueryParameters("a"));
        Assert.assertEquals((Object)"b", (Object)uri.getQueryParameter("a"));
        Assert.assertEquals((Object)"d e", (Object)uri.getQueryParameter("b"));
        Assert.assertEquals((Object)"blah", (Object)uri.getFragment());
    }

    @Test
    public void parseNoPath() {
        Uri uri = Uri.parse((String)"http://apache.org?a=b&a=c&b=d+e#blah");
        Assert.assertEquals((Object)"http", (Object)uri.getScheme());
        Assert.assertEquals((Object)"apache.org", (Object)uri.getAuthority());
        Assert.assertEquals((Object)"", (Object)uri.getPath());
        Assert.assertEquals((Object)"a=b&a=c&b=d+e", (Object)uri.getQuery());
        List<String> params = Arrays.asList("b", "c");
        Assert.assertEquals(params, (Object)uri.getQueryParameters("a"));
        Assert.assertEquals((Object)"b", (Object)uri.getQueryParameter("a"));
        Assert.assertEquals((Object)"d e", (Object)uri.getQueryParameter("b"));
        Assert.assertEquals((Object)"blah", (Object)uri.getFragment());
    }

    @Test
    public void parseNoQuery() {
        Uri uri = Uri.parse((String)"http://apache.org/foo#blah");
        Assert.assertEquals((Object)"http", (Object)uri.getScheme());
        Assert.assertEquals((Object)"apache.org", (Object)uri.getAuthority());
        Assert.assertEquals((Object)"/foo", (Object)uri.getPath());
        Assert.assertNull((Object)uri.getQuery());
        Assert.assertEquals((long)0L, (long)uri.getQueryParameters().size());
        Assert.assertNull((Object)uri.getQueryParameter("foo"));
        Assert.assertEquals((Object)"blah", (Object)uri.getFragment());
    }

    @Test
    public void parseNoFragment() {
        Uri uri = Uri.parse((String)"http://apache.org/foo?a=b&a=c&b=d+e");
        Assert.assertEquals((Object)"http", (Object)uri.getScheme());
        Assert.assertEquals((Object)"apache.org", (Object)uri.getAuthority());
        Assert.assertEquals((Object)"/foo", (Object)uri.getPath());
        Assert.assertEquals((Object)"a=b&a=c&b=d+e", (Object)uri.getQuery());
        Assert.assertNull((Object)uri.getFragment());
    }

    @Test(expected=IllegalArgumentException.class)
    public void parseInvalidHost() {
        Uri.parse((String)"http://A&E%#%#%/foo?a=b#blah");
    }

    @Test(expected=IllegalArgumentException.class)
    public void parseInvalidScheme() {
        Uri.parse((String)"----://apache.org/foo?a=b#blah");
    }

    @Test
    public void parseInvalidPath() {
        Uri uri = Uri.parse((String)"http://apache.org/foo\\---(&%?a=b#blah");
        Assert.assertEquals((Object)"http", (Object)uri.getScheme());
        Assert.assertEquals((Object)"apache.org", (Object)uri.getAuthority());
        Assert.assertEquals((Object)"/foo%5C---(&%25", (Object)uri.getPath());
        Assert.assertEquals((Object)"a=b", (Object)uri.getQuery());
        Assert.assertEquals((Object)"blah", (Object)uri.getFragment());
    }

    @Test
    public void toJavaUri() {
        URI javaUri = URI.create("http://example.org/foo/bar/baz?blah=blah#boo");
        Uri uri = Uri.parse((String)"http://example.org/foo/bar/baz?blah=blah#boo");
        Assert.assertEquals((Object)javaUri, (Object)uri.toJavaUri());
    }

    @Test
    public void toJavaUriWithSpecialChars() {
        URI javaUri = URI.create("http://example.org/foo/bar/baz?blah=bl%25ah#boo");
        Uri uri = Uri.parse((String)"http://example.org/foo/bar/baz?blah=bl%25ah#boo");
        Assert.assertEquals((Object)javaUri, (Object)uri.toJavaUri());
    }

    @Test
    public void fromJavaUri() throws Exception {
        URI javaUri = URI.create("http://example.org/foo/bar/baz?blah=blah#boo");
        Uri uri = Uri.parse((String)"http://example.org/foo/bar/baz?blah=blah#boo");
        Assert.assertEquals((Object)uri, (Object)Uri.fromJavaUri((URI)javaUri));
    }

    @Test
    public void resolveFragment() throws Exception {
        Uri base = Uri.parse((String)"http://example.org/foo/bar/baz?blah=blah#boo");
        Uri other = Uri.parse((String)"#bar");
        Assert.assertEquals((Object)"http://example.org/foo/bar/baz?blah=blah#bar", (Object)base.resolve(other).toString());
    }

    @Test
    public void resolveQuery() throws Exception {
        Uri base = Uri.parse((String)"http://example.org/foo/bar/baz?blah=blah#boo");
        Uri other = Uri.parse((String)"?hello=world");
        Assert.assertEquals((Object)"http://example.org/foo/bar/?hello=world", (Object)base.resolve(other).toString());
    }

    @Test
    public void resolvePathIncludesSubdirs() throws Exception {
        Uri base = Uri.parse((String)"http://example.org/foo/bar/baz?blah=blah#boo");
        Uri other = Uri.parse((String)"fez/../huey/./dewey/../louis");
        Assert.assertEquals((Object)"http://example.org/foo/bar/huey/louis", (Object)base.resolve(other).toString());
    }

    @Ignore
    public void resolvePathSubdirsExtendsBeyondRoot() throws Exception {
        Uri base = Uri.parse((String)"http://example.org/foo/bar/baz?blah=blah#boo");
        Uri other = Uri.parse((String)"../random/../../../../../home");
        Assert.assertEquals((Object)"http://example.org/home", (Object)base.resolve(other).toString());
    }

    @Test
    public void resolvePathRelative() throws Exception {
        Uri base = Uri.parse((String)"http://example.org/foo/bar/baz?blah=blah#boo");
        Uri other = Uri.parse((String)"wee");
        Assert.assertEquals((Object)"http://example.org/foo/bar/wee", (Object)base.resolve(other).toString());
    }

    @Test
    public void resolvePathRelativeToNullPath() throws Exception {
        Uri base = new UriBuilder().setScheme("http").setAuthority("example.org").toUri();
        Uri other = Uri.parse((String)"dir");
        Assert.assertEquals((Object)"http://example.org/dir", (Object)base.resolve(other).toString());
    }

    @Test
    public void resolvePathAbsolute() throws Exception {
        Uri base = Uri.parse((String)"http://example.org/foo/bar/baz?blah=blah#boo");
        Uri other = Uri.parse((String)"/blah");
        Assert.assertEquals((Object)"http://example.org/blah", (Object)base.resolve(other).toString());
    }

    @Test
    public void resolveAuthority() throws Exception {
        Uri base = Uri.parse((String)"https://example.org/foo/bar/baz?blah=blah#boo");
        Uri other = Uri.parse((String)"//example.com/blah");
        Assert.assertEquals((Object)"https://example.com/blah", (Object)base.resolve(other).toString());
    }

    @Test
    public void resolveAbsolute() throws Exception {
        Uri base = Uri.parse((String)"http://example.org/foo/bar/baz?blah=blah#boo");
        Uri other = Uri.parse((String)"http://www.ietf.org/rfc/rfc2396.txt");
        Assert.assertEquals((Object)"http://www.ietf.org/rfc/rfc2396.txt", (Object)base.resolve(other).toString());
    }

    @Test
    public void absoluteUrlIsAbsolute() {
        Assert.assertTrue((String)"Url with scheme not reported absolute.", (boolean)Uri.parse((String)"http://example.org/foo").isAbsolute());
    }

    @Test
    public void relativeUrlIsNotAbsolute() {
        Assert.assertFalse((String)"Url without scheme reported absolute.", (boolean)Uri.parse((String)"//example.org/foo").isAbsolute());
    }

    @Test
    public void parseWithSpecialCharacters() {
        String original = "http://example.org/?foo%25pbar=baz+blah";
        Assert.assertEquals((Object)original, (Object)Uri.parse((String)original).toString());
    }

    @Test
    public void equalsAndHashCodeOk() {
        Uri uri = Uri.parse((String)"http://example.org/foo/bar/baz?blah=blah#boo");
        Uri uri2 = new UriBuilder().setScheme("http").setAuthority("example.org").setPath("/foo/bar/baz").addQueryParameter("blah", "blah").setFragment("boo").toUri();
        Assert.assertEquals((Object)uri, (Object)uri2);
        Assert.assertEquals((Object)uri2, (Object)uri);
        Assert.assertEquals((long)uri.hashCode(), (long)uri2.hashCode());
    }

    @Test
    public void fromJavaUriNasty() throws MalformedURLException {
        Assert.assertEquals((Object)Uri.parse((String)"http://go.warwick.ac.uk/pg/erefs%20.").toString(), (Object)Uri.fromJavaUrl((URL)new URL("http://go.warwick.ac.uk/pg/erefs .")).toString());
        Assert.assertEquals((Object)Uri.parse((String)"http://go.warwick.ac.uk/elj/jilt/00%C3%A2%E2%82%AC%E2%80%9C2/collard.html").toString(), (Object)Uri.fromJavaUrl((URL)new URL("http://go.warwick.ac.uk/elj/jilt/00\u00e2\u20ac\u201c2/collard.html")).toString());
        Assert.assertEquals((Object)Uri.parse((String)"http://go.warwick.ac.uk/pdfjam%22").toString(), (Object)Uri.fromJavaUrl((URL)new URL("http://go.warwick.ac.uk/pdfjam\"")).toString());
        Assert.assertEquals((Object)Uri.parse((String)"http://go.warwick.ac.uk/dtu/pubs/wp/wp44/wp44%20.pdf").toString(), (Object)Uri.fromJavaUrl((URL)new URL("http://go.warwick.ac.uk/dtu/pubs/wp/wp44/wp44 .pdf")).toString());
        Assert.assertEquals((Object)Uri.parse((String)"http://go.warwick.ac.uk/classical%20civilisation").toString(), (Object)Uri.fromJavaUrl((URL)new URL("http://go.warwick.ac.uk/classical civilisation")).toString());
        Assert.assertEquals((Object)Uri.parse((String)"http://go.warwick.ac.uk/history%3E").toString(), (Object)Uri.fromJavaUrl((URL)new URL("http://go.warwick.ac.uk/history>")).toString());
        Assert.assertEquals((Object)Uri.parse((String)"http://go.warwick.ac.uk/chemistry/%20research/chemicalbiology").toString(), (Object)Uri.fromJavaUrl((URL)new URL("http://go.warwick.ac.uk/chemistry/ research/chemicalbiology")).toString());
        Assert.assertEquals((Object)Uri.parse((String)"http://go.warwick.ac.uk/insit%5De").toString(), (Object)Uri.fromJavaUrl((URL)new URL("http://go.warwick.ac.uk/insit]e")).toString());
        Assert.assertEquals((Object)Uri.parse((String)"http://go.warwick.ac.uk/elj/jilt/cal/2%20jones/").toString(), (Object)Uri.fromJavaUrl((URL)new URL("http://go.warwick.ac.uk/elj/jilt/cal/2 jones/")).toString());
        Assert.assertEquals((Object)Uri.parse((String)"http://go.warwick.ac.uk/elj/jilt/03-1/davies.htm%3Cbr%20/%3E").toString(), (Object)Uri.fromJavaUrl((URL)new URL("http://go.warwick.ac.uk/elj/jilt/03-1/davies.htm<br />")).toString());
        Assert.assertEquals((Object)Uri.parse((String)"http://go.warwick.ac.uk/postgraduate%20applications").toString(), (Object)Uri.fromJavaUrl((URL)new URL("http://go.warwick.ac.uk/postgraduate applications")).toString());
        Assert.assertEquals((Object)Uri.parse((String)"http://go.warwick.ac.uk/parishsymposium%3E").toString(), (Object)Uri.fromJavaUrl((URL)new URL("http://go.warwick.ac.uk/parishsymposium>")).toString());
        Assert.assertEquals((Object)Uri.parse((String)"http://go.warwick.ac.uk/%20masgak").toString(), (Object)Uri.fromJavaUrl((URL)new URL("http://go.warwick.ac.uk/ masgak")).toString());
        Assert.assertEquals((Object)Uri.parse((String)"http://www.go.warwick.ac.uk/elj/lgd/2008_1/d%C3%A2%E2%82%AC%E2%84%A2s%20ouza").toString(), (Object)Uri.fromJavaUrl((URL)new URL("http://www.go.warwick.ac.uk/elj/lgd/2008_1/d\u00e2\u20ac\u2122s ouza")).toString());
        Assert.assertEquals((Object)Uri.parse((String)"http://go.warwick.ac.uk/elj/jilt/01-3/byrnes.%20html/").toString(), (Object)Uri.fromJavaUrl((URL)new URL("http://go.warwick.ac.uk/elj/jilt/01-3/byrnes. html/")).toString());
        Assert.assertEquals((Object)Uri.parse((String)"http://go.warwick.ac.uk/calendar/%20and%20the%20guidelines").toString(), (Object)Uri.fromJavaUrl((URL)new URL("http://go.warwick.ac.uk/calendar/ and the guidelines")).toString());
        Assert.assertEquals((Object)Uri.parse((String)"http://go.warwick.ac.uk/%20ugfunding/2010-2011/mbchb").toString(), (Object)Uri.fromJavaUrl((URL)new URL("http://go.warwick.ac.uk/ ugfunding/2010-2011/mbchb")).toString());
        Assert.assertEquals((Object)Uri.parse((String)"http://www2.warwick.ac.uk/go/international/%3C!DOCTYPE").toString(), (Object)Uri.fromJavaUrl((URL)new URL("http://www2.warwick.ac.uk/go/international/<!DOCTYPE")).toString());
        Assert.assertEquals((Object)Uri.parse((String)"http://www2.warwick.ac.uk/go/hefp/%3C!DOCTYPE").toString(), (Object)Uri.fromJavaUrl((URL)new URL("http://www2.warwick.ac.uk/go/hefp/<!DOCTYPE")).toString());
        Assert.assertEquals((Object)Uri.parse((String)"http://go.warwick.ac.uk/dtu/images/dtulogo%20(web).gif").toString(), (Object)Uri.fromJavaUrl((URL)new URL("http://go.warwick.ac.uk/dtu/images/dtulogo (web).gif")).toString());
        Assert.assertEquals((Object)Uri.parse((String)"http://www.go.warwick.ac.uk/shakespeare%22%3Ehttp:/go.warwick.ac.uk/shakespeare%3C/a%3E").toString(), (Object)Uri.fromJavaUrl((URL)new URL("http://www.go.warwick.ac.uk/shakespeare\">http:/go.warwick.ac.uk/shakespeare</a>")).toString());
        Assert.assertEquals((Object)Uri.parse((String)"http://go.warwick.ac.uk/pgapply.%C3%82%20%C3%82").toString(), (Object)Uri.fromJavaUrl((URL)new URL("http://go.warwick.ac.uk/pgapply.\u00c2 \u00c2 ")).toString());
    }

    @Test
    public void opaque() throws Exception {
        Assert.assertEquals((Object)"mailto:m.mannion@warwick.ac.uk", (Object)Uri.parse((String)"mailto:m.mannion@warwick.ac.uk").toString());
        Assert.assertEquals((Object)"gopher:something", (Object)Uri.parse((String)"gopher:something").toString());
        Assert.assertEquals((Object)"ttp://www.google.com", (Object)Uri.parse((String)"ttp://www.google.com").toString());
    }
}

