/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web;

import com.google.common.collect.Lists;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.web.Uri;
import uk.ac.warwick.util.web.UriBuilder;

public class UriBuilderQueryTest {
    private static final Uri URI = Uri.parse((String)"http://www.warwick.ac.uk");

    @Test
    public void parsing() throws Exception {
        String string = "one+one=1&two=2&target=http%3A%2F%2Fwww2.warwick.ac.uk%2Fpage%3Fescaped%3Dyes";
        UriBuilder builder = new UriBuilder(URI).setQuery(string);
        Assert.assertEquals((Object)"1", (Object)builder.getQueryParameter("one one"));
        Assert.assertEquals((Object)"2", (Object)builder.getQueryParameter("two"));
        Assert.assertEquals((Object)"http://www2.warwick.ac.uk/page?escaped=yes", (Object)builder.getQueryParameter("target"));
    }

    @Test
    public void toMap() throws Exception {
        String string = "one+one=1&two=2&target=http%3A%2F%2Fwww2.warwick.ac.uk%2Fpage%3Fescaped%3Dyes";
        UriBuilder builder = new UriBuilder(URI).setQuery(string);
        Map map = builder.getQueryParameters();
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"1"}), map.get("one one"));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"2"}), map.get("two"));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"http://www2.warwick.ac.uk/page?escaped=yes"}), map.get("target"));
    }

    @Test
    public void emptyValue() throws Exception {
        UriBuilder builder = new UriBuilder(URI).setQuery("one=1&two=");
        Assert.assertEquals((Object)"1", (Object)builder.getQueryParameter("one"));
        Assert.assertEquals((Object)"", (Object)builder.getQueryParameter("two"));
        Assert.assertNull((Object)builder.getQueryParameter("three"));
    }

    @Test
    public void totallyEmpty() throws Exception {
        UriBuilder builder = new UriBuilder(URI).setQuery("");
        Assert.assertEquals((Object)"", (Object)builder.getQuery());
        builder.setQuery(null);
        Assert.assertNull((Object)builder.getQuery());
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidEncoding() throws Exception {
        new UriBuilder(URI).setQuery("value=50%");
    }

    @Test
    public void generating() throws Exception {
        UriBuilder builder = new UriBuilder(URI).setQuery("old=yes").addQueryParameter("new", "yes").addQueryParameter("strength", "50%").addQueryParameter("url", "http://example.com/");
        Assert.assertEquals((Object)"old=yes&new=yes&strength=50%25&url=http%3A%2F%2Fexample.com%2F", (Object)builder.getQuery());
    }

    @Test
    public void stripping() throws Exception {
        UriBuilder builder = new UriBuilder(URI).setQuery("view=daily&sbrPage=%2Ffac%2Fsoc%2Fbin&index=3&unwanted=go+away");
        builder.removeQueryParameter("sbrPage").removeQueryParameter("unwanted");
        Assert.assertEquals((Object)"view=daily&index=3", (Object)builder.getQuery());
        Assert.assertNull((Object)builder.getQueryParameter("sbrPage"));
    }
}

