/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.termdates.legacy;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.termdates.legacy.Term;
import uk.ac.warwick.util.termdates.legacy.TermFactoryImpl;
import uk.ac.warwick.util.termdates.legacy.TermImpl;

public class TermImplTest {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("ddMMyy");

    @Test
    public void getWeekNumberIsNotDependantOnMilliseconds() throws Exception {
        LocalDate start = LocalDate.parse("230407", DATE_FORMATTER);
        LocalDate end = LocalDate.parse("300607", DATE_FORMATTER);
        LocalDate firstMonday = LocalDate.of(2007, Month.APRIL, 23);
        LocalDate secondMonday = LocalDate.of(2007, Month.APRIL, 30);
        LocalDate happyMondays = LocalDate.of(2007, Month.MAY, 14);
        TermImpl term = new TermImpl(null, start, end, Term.TermType.summer);
        Assert.assertEquals((long)1L, (long)term.getWeekNumber((Temporal)firstMonday));
        Assert.assertEquals((long)2L, (long)term.getWeekNumber((Temporal)secondMonday));
        Assert.assertEquals((long)4L, (long)term.getWeekNumber((Temporal)happyMondays));
        Assert.assertEquals((long)1L, (long)term.getWeekNumber((Temporal)firstMonday.atStartOfDay().plus(200L, ChronoUnit.MILLIS)));
        Assert.assertEquals((long)2L, (long)term.getWeekNumber((Temporal)secondMonday.atStartOfDay().plus(200L, ChronoUnit.MILLIS)));
    }

    @Test
    public void getAcademicWeekNumber() throws Exception {
        TermFactoryImpl factory = new TermFactoryImpl();
        LocalDateTime week1start = LocalDateTime.of(2009, Month.OCTOBER, 5, 0, 0, 0, 0);
        LocalDateTime week1 = LocalDateTime.of(2009, Month.OCTOBER, 7, 16, 39, 10, 0);
        LocalDateTime week7 = LocalDateTime.of(2009, Month.NOVEMBER, 17, 16, 39, 10, 0);
        LocalDateTime week11 = LocalDateTime.of(2009, Month.DECEMBER, 14, 16, 39, 10, 0);
        LocalDateTime week12 = LocalDateTime.of(2009, Month.DECEMBER, 22, 16, 39, 10, 0);
        LocalDateTime week14 = LocalDateTime.of(2010, Month.JANUARY, 4, 16, 39, 10, 0);
        LocalDateTime week23 = LocalDateTime.of(2010, Month.MARCH, 10, 16, 39, 10, 0);
        LocalDateTime week28 = LocalDateTime.of(2010, Month.APRIL, 15, 16, 39, 10, 0);
        LocalDateTime week39 = LocalDateTime.of(2010, Month.JUNE, 30, 16, 39, 10, 0);
        LocalDateTime week52 = LocalDateTime.of(2010, Month.OCTOBER, 1, 16, 39, 10, 0);
        LocalDateTime week52end = LocalDateTime.of(2010, Month.OCTOBER, 4, 0, 0, 0, 0).minus(1L, ChronoUnit.MILLIS);
        Assert.assertEquals((long)1L, (long)factory.getTermFromDate((Temporal)week1start).getWeekNumber((Temporal)week1start));
        Assert.assertEquals((long)1L, (long)factory.getTermFromDate((Temporal)week1start).getAcademicWeekNumber((Temporal)week1start));
        Assert.assertEquals((long)1L, (long)factory.getTermFromDate((Temporal)week1start).getCumulativeWeekNumber((Temporal)week1start));
        Assert.assertEquals((long)1L, (long)factory.getTermFromDate((Temporal)week1).getWeekNumber((Temporal)week1));
        Assert.assertEquals((long)1L, (long)factory.getTermFromDate((Temporal)week1).getAcademicWeekNumber((Temporal)week1));
        Assert.assertEquals((long)1L, (long)factory.getTermFromDate((Temporal)week1).getCumulativeWeekNumber((Temporal)week1));
        Assert.assertEquals((long)7L, (long)factory.getTermFromDate((Temporal)week7).getWeekNumber((Temporal)week7));
        Assert.assertEquals((long)7L, (long)factory.getTermFromDate((Temporal)week7).getAcademicWeekNumber((Temporal)week7));
        Assert.assertEquals((long)7L, (long)factory.getTermFromDate((Temporal)week7).getCumulativeWeekNumber((Temporal)week7));
        Assert.assertEquals((long)-1L, (long)factory.getTermFromDate((Temporal)week11).getWeekNumber((Temporal)week11));
        Assert.assertEquals((long)11L, (long)factory.getTermFromDate((Temporal)week11).getAcademicWeekNumber((Temporal)week11));
        Assert.assertEquals((long)-1L, (long)factory.getTermFromDate((Temporal)week11).getCumulativeWeekNumber((Temporal)week11));
        Assert.assertEquals((long)-1L, (long)factory.getTermFromDate((Temporal)week12).getWeekNumber((Temporal)week12));
        Assert.assertEquals((long)12L, (long)factory.getTermFromDate((Temporal)week12).getAcademicWeekNumber((Temporal)week12));
        Assert.assertEquals((long)-1L, (long)factory.getTermFromDate((Temporal)week12).getCumulativeWeekNumber((Temporal)week12));
        Assert.assertEquals((long)-1L, (long)factory.getTermFromDate((Temporal)week14).getWeekNumber((Temporal)week14));
        Assert.assertEquals((long)14L, (long)factory.getTermFromDate((Temporal)week14).getAcademicWeekNumber((Temporal)week14));
        Assert.assertEquals((long)-1L, (long)factory.getTermFromDate((Temporal)week14).getCumulativeWeekNumber((Temporal)week14));
        Assert.assertEquals((long)9L, (long)factory.getTermFromDate((Temporal)week23).getWeekNumber((Temporal)week23));
        Assert.assertEquals((long)23L, (long)factory.getTermFromDate((Temporal)week23).getAcademicWeekNumber((Temporal)week23));
        Assert.assertEquals((long)19L, (long)factory.getTermFromDate((Temporal)week23).getCumulativeWeekNumber((Temporal)week23));
        Assert.assertEquals((long)-1L, (long)factory.getTermFromDate((Temporal)week28).getWeekNumber((Temporal)week28));
        Assert.assertEquals((long)28L, (long)factory.getTermFromDate((Temporal)week28).getAcademicWeekNumber((Temporal)week28));
        Assert.assertEquals((long)-1L, (long)factory.getTermFromDate((Temporal)week28).getCumulativeWeekNumber((Temporal)week28));
        Assert.assertEquals((long)10L, (long)factory.getTermFromDate((Temporal)week39).getWeekNumber((Temporal)week39));
        Assert.assertEquals((long)39L, (long)factory.getTermFromDate((Temporal)week39).getAcademicWeekNumber((Temporal)week39));
        Assert.assertEquals((long)30L, (long)factory.getTermFromDate((Temporal)week39).getCumulativeWeekNumber((Temporal)week39));
        Assert.assertEquals((long)-1L, (long)factory.getTermFromDate((Temporal)week52).getWeekNumber((Temporal)week52));
        Assert.assertEquals((long)52L, (long)factory.getTermFromDate((Temporal)week52).getAcademicWeekNumber((Temporal)week52));
        Assert.assertEquals((long)-1L, (long)factory.getTermFromDate((Temporal)week52).getCumulativeWeekNumber((Temporal)week52));
        Assert.assertEquals((long)-1L, (long)factory.getTermFromDate((Temporal)week52end).getWeekNumber((Temporal)week52end));
        Assert.assertEquals((long)52L, (long)factory.getTermFromDate((Temporal)week52end).getAcademicWeekNumber((Temporal)week52end));
        Assert.assertEquals((long)-1L, (long)factory.getTermFromDate((Temporal)week52end).getCumulativeWeekNumber((Temporal)week52end));
        LocalDateTime week53 = week1start.minus(1L, ChronoUnit.MILLIS);
        Assert.assertEquals((long)-1L, (long)factory.getTermFromDate((Temporal)week53).getWeekNumber((Temporal)week53));
        Assert.assertEquals((long)53L, (long)factory.getTermFromDate((Temporal)week53).getAcademicWeekNumber((Temporal)week53));
        Assert.assertEquals((long)-1L, (long)factory.getTermFromDate((Temporal)week53).getCumulativeWeekNumber((Temporal)week53));
    }
}

