/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.termdates;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.Temporal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.spy.memcached.CachedData;
import net.spy.memcached.transcoders.SerializingTranscoder;
import org.junit.Assert;
import org.junit.Test;
import org.threeten.extra.LocalDateRange;
import uk.ac.warwick.util.termdates.AcademicWeek;
import uk.ac.warwick.util.termdates.AcademicYear;
import uk.ac.warwick.util.termdates.AcademicYearPeriod;
import uk.ac.warwick.util.termdates.Vacation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\b\u0010\t\u001a\u00020\u0004H\u0007J\b\u0010\n\u001a\u00020\u0004H\u0007J\b\u0010\u000b\u001a\u00020\u0004H\u0007J\b\u0010\f\u001a\u00020\u0004H\u0007J\b\u0010\r\u001a\u00020\u0004H\u0007J\b\u0010\u000e\u001a\u00020\u0004H\u0007\u00a8\u0006\u000f"}, d2={"Luk/ac/warwick/util/termdates/AcademicYearTest;", "", "()V", "SBTWO-3948", "", "TAB-2625", "enoughDates", "getAcademicWeeksForYear", "getAcademicWeeksForYear2014", "getAcademicWeeksForYear2015", "legacyCompatible", "sanityCheck2011", "sanityCheck2017", "sanityCheckData", "serializable", "warwickutils-core"})
public final class AcademicYearTest {
    @Test
    public final void sanityCheck2011() {
        AcademicYear year = AcademicYear.starting((int)2011);
        AcademicWeek firstWeek = year.getAcademicWeek((Temporal)LocalDate.of(2011, Month.AUGUST, 1));
        Assert.assertEquals((long)-8L, (long)firstWeek.getWeekNumber());
        Assert.assertEquals((String)"Starts on a Monday", (Object)LocalDate.of(2011, Month.AUGUST, 1), (Object)firstWeek.getDateRange().getStart());
        Assert.assertEquals((Object)LocalDate.of(2011, Month.AUGUST, 7), (Object)firstWeek.getDateRange().getEndInclusive());
        AcademicYearPeriod academicYearPeriod = year.getPeriod(AcademicYearPeriod.PeriodType.preTermVacation);
        Intrinsics.checkNotNull((Object)academicYearPeriod, (String)"null cannot be cast to non-null type uk.ac.warwick.util.termdates.Vacation");
        Vacation preTermVacation = (Vacation)academicYearPeriod;
        Assert.assertEquals((long)-8L, (long)preTermVacation.getFirstWeek().getWeekNumber());
        Assert.assertEquals((String)"Starts on a Monday", (Object)LocalDate.of(2011, Month.AUGUST, 1), (Object)preTermVacation.getFirstWeek().getDateRange().getStart());
        AcademicWeek week0 = preTermVacation.getLastWeek();
        Assert.assertEquals((long)0L, (long)week0.getWeekNumber());
    }

    @Test
    public final void sanityCheck2017() {
        AcademicYear year = AcademicYear.starting((int)2017);
        AcademicWeek firstWeek = year.getAcademicWeek((Temporal)LocalDate.of(2017, Month.AUGUST, 1));
        Assert.assertEquals((long)-8L, (long)firstWeek.getWeekNumber());
        Assert.assertEquals((String)"Starts on a Tuesday", (Object)LocalDate.of(2017, Month.AUGUST, 1), (Object)firstWeek.getDateRange().getStart());
        Assert.assertEquals((Object)LocalDate.of(2017, Month.AUGUST, 6), (Object)firstWeek.getDateRange().getEndInclusive());
        AcademicYearPeriod academicYearPeriod = year.getPeriod(AcademicYearPeriod.PeriodType.preTermVacation);
        Intrinsics.checkNotNull((Object)academicYearPeriod, (String)"null cannot be cast to non-null type uk.ac.warwick.util.termdates.Vacation");
        Vacation preTermVacation = (Vacation)academicYearPeriod;
        Assert.assertEquals((long)-8L, (long)preTermVacation.getFirstWeek().getWeekNumber());
        Assert.assertEquals((String)"Starts on a Tuesday", (Object)LocalDate.of(2017, Month.AUGUST, 1), (Object)preTermVacation.getFirstWeek().getDateRange().getStart());
        AcademicWeek week0 = preTermVacation.getLastWeek();
        Assert.assertEquals((long)0L, (long)week0.getWeekNumber());
    }

    @Test
    public final void sanityCheckData() {
        for (int startYear = 2006; startYear < 2026; ++startYear) {
            AcademicYear year = AcademicYear.starting((int)startYear);
            Assert.assertEquals((Object)year, (Object)AcademicYear.forDate((Temporal)LocalDate.of(startYear + 1, Month.APRIL, 23)));
            StringBuilder stringBuilder = new StringBuilder();
            String string = String.valueOf(startYear).substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            Assert.assertEquals((Object)year, (Object)AcademicYear.parse((String)stringBuilder.append(string).append("/99").toString()));
            Assert.assertEquals((long)startYear, (long)year.getStartYear());
            Assert.assertEquals((long)startYear, (long)year.getValue());
            String string2 = year.getLabel();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLabel(...)");
            StringBuilder stringBuilder2 = new StringBuilder();
            String string3 = String.valueOf(startYear).substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            Assert.assertTrue((boolean)StringsKt.startsWith$default((String)string2, (String)stringBuilder2.append(string3).append('/').toString(), (boolean)false, (int)2, null));
            Assert.assertEquals((String)"Should have all 7 periods", (long)7L, (long)year.getPeriods().size());
            Assert.assertTrue((String)"Always start with a vacation", (boolean)((AcademicYearPeriod)year.getPeriods().iterator().next()).isVacation());
            AcademicYearPeriod lastPeriod = null;
            for (AcademicYearPeriod period : year.getPeriods()) {
                AcademicYearPeriod.PeriodType periodType = period.getType();
                switch (periodType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[periodType.ordinal()]) {
                    case 1: {
                        Assert.assertTrue((String)"Pre-term vacation always starts in week -8 or -9", (period.getFirstWeek().getWeekNumber() <= -8 ? 1 : 0) != 0);
                        Assert.assertEquals((String)"Pre-term vacation always ends with week 0", (long)0L, (long)period.getLastWeek().getWeekNumber());
                        break;
                    }
                    case 2: {
                        Assert.assertEquals((String)"Autumn term always starts with week 1", (long)1L, (long)period.getFirstWeek().getWeekNumber());
                        Assert.assertEquals((String)"Autumn term always ends with week 10", (long)10L, (long)period.getLastWeek().getWeekNumber());
                        Assert.assertEquals((String)"Autumn is Term 1", (long)1L, (long)period.getType().getTermNumber());
                        break;
                    }
                    case 3: {
                        Assert.assertEquals((String)"Christmas vacation always starts with week 11", (long)11L, (long)period.getFirstWeek().getWeekNumber());
                    }
                }
                Assert.assertEquals((Object)year, (Object)period.getYear());
                Assert.assertEquals((Object)period, (Object)period.getFirstWeek().getPeriod());
                Assert.assertEquals((Object)year, (Object)period.getFirstWeek().getYear());
                Assert.assertEquals((Object)period, (Object)period.getLastWeek().getPeriod());
                Assert.assertEquals((Object)year, (Object)period.getLastWeek().getYear());
                if (lastPeriod != null) {
                    Assert.assertTrue((lastPeriod.compareTo(period) < 0 ? 1 : 0) != 0);
                    Assert.assertTrue((period.compareTo(lastPeriod) > 0 ? 1 : 0) != 0);
                    Assert.assertEquals((String)"Week should follow on from previous", (long)(lastPeriod.getLastWeek().getWeekNumber() + 1), (long)period.getFirstWeek().getWeekNumber());
                }
                lastPeriod = period;
            }
            Assert.assertTrue((String)"Should have at least 52 weeks", (year.getAcademicWeeks().size() >= 52 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Should have at most 53 weeks", (year.getAcademicWeeks().size() <= 53 ? 1 : 0) != 0);
            Assert.assertTrue((String)"First week number should be negative", (((AcademicWeek)year.getAcademicWeeks().iterator().next()).getWeekNumber() < 0 ? 1 : 0) != 0);
            Assert.assertEquals((String)"First week should always start on 01/08", (Object)LocalDate.of(startYear, Month.AUGUST, 1), (Object)((AcademicWeek)year.getAcademicWeeks().iterator().next()).getDateRange().getStart());
            Assert.assertEquals((String)"Last week should always end on 31/07", (Object)LocalDate.of(startYear + 1, Month.JULY, 31), (Object)((AcademicWeek)year.getAcademicWeeks().get(year.getAcademicWeeks().size() - 1)).getDateRange().getEndInclusive());
            AcademicWeek lastWeek = null;
            for (AcademicWeek week : year.getAcademicWeeks()) {
                if (lastWeek != null) {
                    Assert.assertTrue((lastWeek.compareTo(week) < 0 ? 1 : 0) != 0);
                    Assert.assertTrue((week.compareTo(lastWeek) > 0 ? 1 : 0) != 0);
                    Assert.assertEquals((String)"Week should follow on from previous", (long)(lastWeek.getWeekNumber() + 1), (long)week.getWeekNumber());
                    Assert.assertEquals((String)"Sits week should follow on from previous", (long)(lastWeek.getSitsWeekNumber() + 1), (long)week.getSitsWeekNumber());
                }
                if (week.getPeriod().isTerm()) {
                    Assert.assertTrue((week.getTermWeekNumber() > 0 ? 1 : 0) != 0);
                    Assert.assertTrue((week.getCumulativeWeekNumber() > 0 ? 1 : 0) != 0);
                }
                Assert.assertTrue((String)"Sits week numbers start from 1 so they can never be negative (we return 0 for the week before the first Monday of August)", (week.getSitsWeekNumber() >= 0 ? 1 : 0) != 0);
                lastWeek = week;
            }
        }
    }

    @Test
    public final void legacyCompatible() {
        AcademicYear year = AcademicYear.starting((int)2006);
        AcademicYearPeriod period = year.getPeriod((Temporal)LocalDate.of(2007, Month.APRIL, 23));
        Assert.assertTrue((boolean)period.isTerm());
        Assert.assertEquals((Object)AcademicYearPeriod.PeriodType.summerTerm, (Object)period.getType());
        AcademicWeek week = year.getAcademicWeek((Temporal)LocalDate.of(2007, Month.APRIL, 23));
        Assert.assertEquals((Object)period, (Object)week.getPeriod());
        Assert.assertEquals((Object)year, (Object)week.getYear());
        Assert.assertEquals((long)30L, (long)week.getWeekNumber());
        Assert.assertEquals((long)1L, (long)week.getTermWeekNumber());
        Assert.assertEquals((long)21L, (long)week.getCumulativeWeekNumber());
        Assert.assertEquals((long)38L, (long)week.getSitsWeekNumber());
        Assert.assertEquals((Object)LocalDateRange.of((LocalDate)LocalDate.of(2007, Month.APRIL, 23), (LocalDate)LocalDate.of(2007, Month.APRIL, 30)), (Object)week.getDateRange());
    }

    @Test
    public final void enoughDates() {
        AcademicYear now = AcademicYear.forDate((Temporal)LocalDate.now());
        for (AcademicYear year : now.yearsSurrounding(0, 3)) {
            Assert.assertFalse((String)("There is no data for academic year " + year), (boolean)year.getPeriods().isEmpty());
        }
    }

    @Test
    public final void getAcademicWeeksForYear() {
        AcademicYear year = AcademicYear.forDate((Temporal)LocalDate.of(2007, Month.APRIL, 23));
        Assert.assertEquals((long)53L, (long)year.getAcademicWeeks().size());
        AcademicWeek week1 = year.getAcademicWeek(1);
        Assert.assertEquals((long)1L, (long)week1.getWeekNumber());
        Assert.assertEquals((Object)LocalDateRange.of((LocalDate)LocalDate.of(2006, Month.OCTOBER, 2), (LocalDate)LocalDate.of(2006, Month.OCTOBER, 9)), (Object)week1.getDateRange());
        AcademicWeek week10 = year.getAcademicWeek(10);
        Assert.assertEquals((long)10L, (long)week10.getWeekNumber());
        Assert.assertEquals((Object)LocalDateRange.of((LocalDate)LocalDate.of(2006, Month.DECEMBER, 4), (LocalDate)LocalDate.of(2006, Month.DECEMBER, 11)), (Object)week10.getDateRange());
        AcademicWeek week20 = year.getAcademicWeek(20);
        Assert.assertEquals((long)20L, (long)week20.getWeekNumber());
        Assert.assertEquals((Object)LocalDateRange.of((LocalDate)LocalDate.of(2007, Month.FEBRUARY, 12), (LocalDate)LocalDate.of(2007, Month.FEBRUARY, 19)), (Object)week20.getDateRange());
        AcademicWeek week30 = year.getAcademicWeek(30);
        Assert.assertEquals((long)30L, (long)week30.getWeekNumber());
        Assert.assertEquals((Object)LocalDateRange.of((LocalDate)LocalDate.of(2007, Month.APRIL, 23), (LocalDate)LocalDate.of(2007, Month.APRIL, 30)), (Object)week30.getDateRange());
    }

    @Test
    public final void getAcademicWeeksForYear2014() {
        AcademicYear year = AcademicYear.forDate((Temporal)LocalDate.of(2014, Month.NOVEMBER, 1));
        Assert.assertEquals((long)53L, (long)year.getAcademicWeeks().size());
        AcademicWeek week1 = year.getAcademicWeek(1);
        Assert.assertEquals((long)1L, (long)week1.getWeekNumber());
        Assert.assertEquals((Object)LocalDateRange.of((LocalDate)LocalDate.of(2014, Month.SEPTEMBER, 29), (LocalDate)LocalDate.of(2014, Month.OCTOBER, 6)), (Object)week1.getDateRange());
        AcademicWeek week42 = year.getAcademicWeek(42);
        Assert.assertEquals((long)42L, (long)week42.getWeekNumber());
        Assert.assertEquals((Object)LocalDateRange.of((LocalDate)LocalDate.of(2015, Month.JULY, 13), (LocalDate)LocalDate.of(2015, Month.JULY, 20)), (Object)week42.getDateRange());
    }

    @Test
    public final void getAcademicWeeksForYear2015() {
        AcademicYear year = AcademicYear.forDate((Temporal)LocalDate.of(2015, Month.NOVEMBER, 1));
        Assert.assertEquals((long)53L, (long)year.getAcademicWeeks().size());
        AcademicWeek week1 = year.getAcademicWeek(1);
        Assert.assertEquals((long)1L, (long)week1.getWeekNumber());
        Assert.assertEquals((Object)LocalDateRange.of((LocalDate)LocalDate.of(2015, Month.OCTOBER, 5), (LocalDate)LocalDate.of(2015, Month.OCTOBER, 12)), (Object)week1.getDateRange());
        AcademicWeek week42 = year.getAcademicWeek(42);
        Assert.assertEquals((long)42L, (long)week42.getWeekNumber());
        Assert.assertEquals((Object)LocalDateRange.of((LocalDate)LocalDate.of(2016, Month.JULY, 18), (LocalDate)LocalDate.of(2016, Month.JULY, 25)), (Object)week42.getDateRange());
    }

    @Test
    public final void SBTWO-3948() {
        LocalDate monday = LocalDate.of(2011, Month.APRIL, 25);
        AcademicYear year = AcademicYear.forDate((Temporal)monday);
        AcademicYearPeriod term = year.getPeriod((Temporal)monday);
        Assert.assertEquals((Object)LocalDate.of(2011, Month.APRIL, 25), (Object)term.getFirstDay());
        Assert.assertEquals((Object)LocalDate.of(2011, Month.JULY, 3), (Object)term.getLastDay());
        Assert.assertEquals((Object)AcademicYearPeriod.PeriodType.summerTerm, (Object)term.getType());
        Assert.assertEquals((long)1L, (long)year.getAcademicWeek((Temporal)monday).getTermWeekNumber());
        Assert.assertEquals((long)30L, (long)year.getAcademicWeek((Temporal)monday).getWeekNumber());
        Assert.assertEquals((long)21L, (long)year.getAcademicWeek((Temporal)monday).getCumulativeWeekNumber());
        Assert.assertEquals((long)39L, (long)year.getAcademicWeek((Temporal)monday).getSitsWeekNumber());
        Assert.assertEquals((long)1L, (long)year.getAcademicWeek((Temporal)monday.with(DayOfWeek.SATURDAY)).getTermWeekNumber());
        Assert.assertEquals((long)30L, (long)year.getAcademicWeek((Temporal)monday.with(DayOfWeek.SATURDAY)).getWeekNumber());
        Assert.assertEquals((long)21L, (long)year.getAcademicWeek((Temporal)monday.with(DayOfWeek.SATURDAY)).getCumulativeWeekNumber());
        Assert.assertEquals((long)39L, (long)year.getAcademicWeek((Temporal)monday.with(DayOfWeek.SATURDAY)).getSitsWeekNumber());
        Assert.assertEquals((long)2L, (long)year.getAcademicWeek((Temporal)monday.plusWeeks(1L)).getTermWeekNumber());
        Assert.assertEquals((long)31L, (long)year.getAcademicWeek((Temporal)monday.plusWeeks(1L)).getWeekNumber());
        Assert.assertEquals((long)22L, (long)year.getAcademicWeek((Temporal)monday.plusWeeks(1L)).getCumulativeWeekNumber());
        Assert.assertEquals((long)40L, (long)year.getAcademicWeek((Temporal)monday.plusWeeks(1L)).getSitsWeekNumber());
    }

    @Test
    public final void TAB-2625() {
        LocalDate monday = LocalDate.of(2011, Month.APRIL, 25);
        AcademicYear year = AcademicYear.forDate((Temporal)monday);
        AcademicYearPeriod term = year.getPeriod((Temporal)monday);
        Assert.assertEquals((Object)term, (Object)year.getPeriod((Temporal)term.getLastDay()));
    }

    @Test
    public final void serializable() {
        SerializingTranscoder transcoder = new SerializingTranscoder();
        AcademicYear year = AcademicYear.starting((int)2017);
        CachedData encoded = transcoder.encode((Object)year);
        Assert.assertNotNull((Object)encoded);
        Assert.assertEquals((Object)year, (Object)transcoder.decode(encoded));
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AcademicYearPeriod.PeriodType.values().length];
            try {
                nArray[AcademicYearPeriod.PeriodType.preTermVacation.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AcademicYearPeriod.PeriodType.autumnTerm.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AcademicYearPeriod.PeriodType.christmasVacation.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

