/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.queue.conversion;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import uk.ac.warwick.util.queue.conversion.ItemType;
import uk.ac.warwick.util.queue.conversion.TestServiceBean;

@JsonAutoDetect
@ItemType(value="my-message-type")
@JsonPropertyOrder(value={"name", "currentAge"})
public class TestItem {
    private String name;
    private int currentAge;
    private transient TestServiceBean testServiceBean;
    private List<TestItem> children = new ArrayList<TestItem>();

    public TestItem() {
    }

    public TestItem(String name, int currentAge) {
        this.name = name;
        this.currentAge = currentAge;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getCurrentAge() {
        return this.currentAge;
    }

    public void setCurrentAge(int currentAge) {
        this.currentAge = currentAge;
    }

    @JsonIgnore
    public TestServiceBean getTestServiceBean() {
        return this.testServiceBean;
    }

    @Autowired
    public void setTestServiceBean(TestServiceBean testServiceBean) {
        this.testServiceBean = testServiceBean;
    }

    @JsonSerialize
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public List<TestItem> getChildren() {
        return this.children;
    }

    public void setChildren(List<TestItem> children) {
        this.children = children;
    }

    public TestItem addChild(TestItem child) {
        this.children.add(child);
        return this;
    }
}

