/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.queue;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.jmock.Expectations;
import org.jmock.api.ThreadingPolicy;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.concurrent.Synchroniser;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.jms.support.converter.MessageConverter;
import uk.ac.warwick.util.queue.Queue;
import uk.ac.warwick.util.queue.QueueListener;
import uk.ac.warwick.util.queue.QueueProvider;
import uk.ac.warwick.util.queue.activemq.ActiveMQQueueProvider;
import uk.ac.warwick.util.queue.conversion.ItemType;
import uk.ac.warwick.util.queue.conversion.JsonMessageConverter;

public class ActiveMQQueueProviderTest {
    private QueueProvider queueProvider;
    private Queue queue;
    private Queue unrelatedQueue;

    @Before
    public void create() throws Exception {
        this.queueProvider = ActiveMQQueueProvider.createEmbeddedBroker();
        this.queue = this.queueProvider.getQueue("Test.Messages");
        this.unrelatedQueue = this.queueProvider.getQueue("Test.SomeOtherMessages");
    }

    @Test
    public void sendStringMessage() throws Exception {
        MyListener listener = new MyListener();
        this.queue.addListener(null, (QueueListener)listener);
        this.queue.send((Object)"Hello from JUnit");
        this.queue.send((Object)"Hello from JUnit again");
        Thread.sleep(300L);
        Assert.assertEquals((long)2L, (long)listener.getMessagesReceived());
    }

    @Test
    public void sendJsonMessage() throws Exception {
        JsonMessageConverter jsonConverter = new JsonMessageConverter();
        jsonConverter.setAnnotatedClasses((List)Lists.newArrayList((Object[])new Class[]{EncodeVideoJob.class, GrabMetadataJob.class}));
        this.queue.setMessageConverter((MessageConverter)jsonConverter);
        this.unrelatedQueue.send((Object)"Hello!");
        JUnit4Mockery m = new JUnit4Mockery(){
            {
                this.setThreadingPolicy((ThreadingPolicy)new Synchroniser());
            }
        };
        final QueueListener listener = (QueueListener)m.mock(QueueListener.class);
        m.checking((ExpectationBuilder)new Expectations(){
            {
                ((QueueListener)this.exactly(1).of((Object)listener)).isListeningToQueue();
                this.will(2.returnValue((Object)true));
                ((QueueListener)this.one(listener)).onReceive(this.with(2.any(EncodeVideoJob.class)));
                ((QueueListener)this.one(listener)).onReceive(this.with(2.any(GrabMetadataJob.class)));
            }
        });
        this.queue.setSingleListener(listener);
        EncodeVideoJob encode = new EncodeVideoJob();
        encode.setFilename("myfile.mp4");
        encode.setBitrate(9000);
        encode.setFormat("H264");
        this.queue.send((Object)encode);
        GrabMetadataJob metadata = new GrabMetadataJob();
        metadata.setPageUrl("/services/its/myfile.mp4");
        this.queue.send((Object)metadata);
        Thread.sleep(300L);
        m.assertIsSatisfied();
    }

    @Test
    public void nonListeningListener() throws Exception {
        JUnit4Mockery m = new JUnit4Mockery();
        final QueueListener listener = (QueueListener)m.mock(QueueListener.class);
        m.checking((ExpectationBuilder)new Expectations(){
            {
                ((QueueListener)this.exactly(1).of((Object)listener)).isListeningToQueue();
                this.will(3.returnValue((Object)false));
            }
        });
        this.queue.setSingleListener(listener);
        this.queue.send((Object)"Pow!");
        Thread.sleep(3000L);
        m.assertIsSatisfied();
    }

    @Test(timeout=30000L)
    public void thatsNoMoonItsASpaceStation() throws Exception {
        MyListener listener1 = new MyListener();
        MyListener listener2 = new MyListener();
        this.queue.setPubSub(true);
        this.queue.addListener(null, (QueueListener)listener1);
        this.queue.addListener(null, (QueueListener)listener2);
        this.queue.send((Object)"Pow!");
        while (listener1.getMessagesReceived() < 0) {
            Thread.sleep(100L);
        }
        while (listener2.getMessagesReceived() < 0) {
            Thread.sleep(100L);
        }
    }

    @After
    public void destroy() throws Exception {
        this.queueProvider.destroy();
    }

    @AfterClass
    public static void checkEmbeddedProvider() {
        Assert.assertFalse((String)"Embedded queue shouldn't create activemq-data directory", (boolean)new File("activemq-data").exists());
    }

    public static class MyListener
    implements QueueListener {
        private int messagesReceived;

        public void onReceive(Object message) {
            ++this.messagesReceived;
        }

        public int getMessagesReceived() {
            return this.messagesReceived;
        }

        public boolean isListeningToQueue() {
            return true;
        }
    }

    @ItemType(value="GrabMetadataJob")
    @JsonAutoDetect
    public static class GrabMetadataJob {
        private String pageUrl;

        public String getPageUrl() {
            return this.pageUrl;
        }

        public void setPageUrl(String pageUrl) {
            this.pageUrl = pageUrl;
        }
    }

    @ItemType(value="EncodeVideoJob")
    @JsonAutoDetect
    public static class EncodeVideoJob {
        private String filename;
        private String format;
        private int bitrate;

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public int getBitrate() {
            return this.bitrate;
        }

        public void setBitrate(int bitrate) {
            this.bitrate = bitrate;
        }
    }
}

