/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.queue;

import javax.annotation.Resource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jmock.Expectations;
import org.jmock.api.ThreadingPolicy;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.concurrent.Synchroniser;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import uk.ac.warwick.util.queue.ActiveMQQueueProviderTest;
import uk.ac.warwick.util.queue.Queue;
import uk.ac.warwick.util.queue.QueueListener;
import uk.ac.warwick.util.queue.SendForHelp;
import uk.ac.warwick.util.queue.activemq.ActiveMQQueueProvider;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"test-queue-context.xml"})
public class ActiveMQQueueProviderSpringTest {
    @Autowired
    private ActiveMQQueueProvider queueProvider;
    @Resource(name="sitebuilderJobQueue")
    private Queue sitebuilderQueue;
    @Resource(name="unimportantStuffQueue")
    private Queue unimportantStuffQueue;

    @Test
    public void spring() {
        Assert.assertNotNull((Object)this.queueProvider);
    }

    @DirtiesContext
    @Test
    public void annotationConverter() throws Exception {
        JUnit4Mockery m = new JUnit4Mockery(){
            {
                this.setThreadingPolicy((ThreadingPolicy)new Synchroniser());
            }
        };
        ActiveMQQueueProviderTest.GrabMetadataJob job = new ActiveMQQueueProviderTest.GrabMetadataJob();
        job.setPageUrl("/services/wibble.ogg");
        final QueueListener listener = (QueueListener)m.mock(QueueListener.class);
        m.checking((ExpectationBuilder)new Expectations(){
            {
                ((QueueListener)this.exactly(1).of((Object)listener)).isListeningToQueue();
                this.will(2.returnValue((Object)true));
                ((QueueListener)this.exactly(1).of((Object)listener)).onReceive(this.with(Matchers.hasProperty((String)"pageUrl", (Matcher)2.equal((Object)"/services/wibble.ogg"))));
            }
        });
        this.sitebuilderQueue.setSingleListener(listener);
        this.sitebuilderQueue.send((Object)job);
        Thread.sleep(300L);
        m.assertIsSatisfied();
    }

    @DirtiesContext
    @Test
    public void moreAnnotationConversion() throws Exception {
        JUnit4Mockery m = new JUnit4Mockery(){
            {
                this.setThreadingPolicy((ThreadingPolicy)new Synchroniser());
            }
        };
        final QueueListener listener = (QueueListener)m.mock(QueueListener.class);
        m.checking((ExpectationBuilder)new Expectations(){
            {
                ((QueueListener)this.exactly(1).of((Object)listener)).isListeningToQueue();
                this.will(4.returnValue((Object)true));
                ((QueueListener)this.exactly(1).of((Object)listener)).onReceive(this.with(Matchers.allOf((Matcher)4.any(SendForHelp.class), (Matcher)Matchers.hasProperty((String)"from", (Matcher)4.equal((Object)"alan@introuble.example.com")), (Matcher)Matchers.hasProperty((String)"to", (Matcher)4.equal((Object)"bill@savetheday.example.com")), (Matcher)Matchers.hasProperty((String)"transientData", (Matcher)Matchers.is((Matcher)Matchers.nullValue())))));
            }
        });
        this.unimportantStuffQueue.setSingleListener(listener);
        SendForHelp help = new SendForHelp();
        help.setFrom("alan@introuble.example.com");
        help.setTo("bill@savetheday.example.com");
        help.setTransientData("This shouldn't get stored in the message.");
        this.unimportantStuffQueue.send((Object)help);
        Thread.sleep(300L);
        m.assertIsSatisfied();
    }
}

