/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mail;

import java.io.IOException;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.mail.MimeMessageUtilities;

public class MimeMessageUtilitiesTest {
    @Test
    public void itWorks() throws MessagingException, IOException {
        MimeMessage mail = this.getTestMessage();
        String s = MimeMessageUtilities.mimeMessageToString((MimeMessage)mail, (boolean)true);
        Assert.assertTrue((String)"toString contains subject", (boolean)s.contains("Geese in building"));
        Assert.assertTrue((String)"toString contains plain text part", (boolean)s.contains("raise P2 incident"));
        Assert.assertTrue((String)"toString contains HTML part", (boolean)s.contains("raise <strong>P2</strong> incident"));
        Assert.assertTrue((String)"toString contains recipient", (boolean)s.contains("helpdesk@warwick.ac.uk"));
    }

    @Test
    public void bodyCanBeSuppressedWithFlag() throws MessagingException, IOException {
        MimeMessage mail = this.getTestMessage();
        String s = MimeMessageUtilities.mimeMessageToString((MimeMessage)mail, (boolean)false);
        Assert.assertTrue((String)"toString contains subject", (boolean)s.contains("Geese in building"));
        Assert.assertFalse((String)"toString contains plain text part", (boolean)s.contains("raise P2 incident"));
        Assert.assertFalse((String)"toString contains HTML part", (boolean)s.contains("raise <strong>P2</strong> incident"));
        Assert.assertTrue((String)"toString contains redaction message", (boolean)s.contains("Redacted"));
        Assert.assertTrue((String)"toString contains recipient", (boolean)s.contains("helpdesk@warwick.ac.uk"));
    }

    private MimeMessage getTestMessage() throws MessagingException {
        MimeMessage mail = new MimeMessage((Session)null);
        mail.setRecipients(Message.RecipientType.TO, "helpdesk@warwick.ac.uk");
        mail.setSubject("Geese in building");
        MimeBodyPart textPart = new MimeBodyPart();
        textPart.setText("Please raise P2 incident for geese.", "utf-8");
        MimeBodyPart htmlPart = new MimeBodyPart();
        htmlPart.setContent((Object)"Please raise <strong>P2</strong> incident for geese.", "text/html; charset=utf-8");
        MimeMultipart multipart = new MimeMultipart("alternative");
        multipart.addBodyPart((BodyPart)textPart);
        multipart.addBodyPart((BodyPart)htmlPart);
        mail.setContent((Multipart)multipart);
        return mail;
    }
}

