/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.httpclient.httpclient4;

import junit.framework.TestCase;
import org.apache.http.client.CookieStore;
import uk.ac.warwick.userlookup.User;
import uk.ac.warwick.util.collections.Pair;
import uk.ac.warwick.util.httpclient.httpclient4.HttpMethodExecutor;
import uk.ac.warwick.util.httpclient.httpclient4.WebServiceHttpMethodExecutor;

public class WebServiceHttpMethodExecutorTest
extends TestCase {
    public void testItWorks() throws Exception {
        WebServiceHttpMethodExecutor ex = new WebServiceHttpMethodExecutor(HttpMethodExecutor.Method.get, "http://www.warwick.ac.uk", ".warwick.ac.uk", new User());
        Pair result = ex.execute(HttpMethodExecutor.RESPONSE_AS_BYTES);
        WebServiceHttpMethodExecutorTest.assertEquals((int)200, (int)((Integer)result.getLeft()));
        WebServiceHttpMethodExecutorTest.assertNotNull((Object)result.getRight());
    }

    public void testItSendsCookie() throws Exception {
        User user = new User();
        user.setOldWarwickSSOToken("ssotoken");
        user.setIsLoggedIn(true);
        WebServiceHttpMethodExecutor ex = new WebServiceHttpMethodExecutor(HttpMethodExecutor.Method.get, "http://www.warwick.ac.uk", ".warwick.ac.uk", user);
        ex.setSSOCookie(true);
        Pair result = ex.execute(HttpMethodExecutor.RESPONSE_AS_BYTES);
        WebServiceHttpMethodExecutorTest.assertEquals((int)200, (int)((Integer)result.getLeft()));
        CookieStore store = (CookieStore)ex.getContext().getAttribute("http.cookie-store");
        WebServiceHttpMethodExecutorTest.assertNotNull((Object)store);
        WebServiceHttpMethodExecutorTest.assertEquals((int)1, (int)store.getCookies().size());
    }

    public void testUnsupportedOperation() throws Exception {
        WebServiceHttpMethodExecutor ex = new WebServiceHttpMethodExecutor(HttpMethodExecutor.Method.head, "http://www.warwick.ac.uk", ".warwick.ac.uk", new User());
        try {
            ex.setHttpClientFactoryStrategyAsString("always");
            WebServiceHttpMethodExecutorTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            ex.setSSOCookie(true);
        }
        catch (UnsupportedOperationException e) {
            WebServiceHttpMethodExecutorTest.fail();
        }
    }
}

