/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.hibernate4;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.jmock.Expectations;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.hibernate4.OracleEmptyStringUserType;
import uk.ac.warwick.util.hibernate4.UserTypeTestBase;

public final class OracleEmptyStringUserTypeTest
extends UserTypeTestBase {
    @Test
    public void getNotEmpty() throws Exception {
        OracleEmptyStringUserType type = OracleEmptyStringUserType.INSTANCE;
        String columnName = "STRING_VALUE";
        final ResultSet rs = (ResultSet)this.m.mock(ResultSet.class);
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((ResultSet)this.oneOf(rs)).getString("STRING_VALUE");
                this.will(1.returnValue((Object)"something"));
                ((ResultSet)this.oneOf(rs)).wasNull();
                this.will(1.returnValue((Object)false));
            }
        });
        String str = type.nullSafeGet(rs, new String[]{"STRING_VALUE"}, this.sessionImplementor, null);
        Assert.assertNotNull((Object)str);
        Assert.assertEquals((Object)"something", (Object)str);
        this.m.assertIsSatisfied();
    }

    @Test
    public void getEmpty() throws Exception {
        OracleEmptyStringUserType type = OracleEmptyStringUserType.INSTANCE;
        String columnName = "STRING_VALUE";
        final ResultSet rs = (ResultSet)this.m.mock(ResultSet.class);
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((ResultSet)this.oneOf(rs)).getString("STRING_VALUE");
                this.will(2.returnValue((Object)"<EmptyString/>"));
                ((ResultSet)this.oneOf(rs)).wasNull();
                this.will(2.returnValue((Object)false));
            }
        });
        String str = type.nullSafeGet(rs, new String[]{"STRING_VALUE"}, this.sessionImplementor, null);
        Assert.assertNotNull((Object)str);
        Assert.assertEquals((Object)"", (Object)str);
        this.m.assertIsSatisfied();
    }

    @Test
    public void getNull() throws Exception {
        OracleEmptyStringUserType type = OracleEmptyStringUserType.INSTANCE;
        String columnName = "STRING_VALUE";
        final ResultSet rs = (ResultSet)this.m.mock(ResultSet.class);
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((ResultSet)this.oneOf(rs)).getString("STRING_VALUE");
                this.will(3.returnValue(null));
            }
        });
        String str = type.nullSafeGet(rs, new String[]{"STRING_VALUE"}, this.sessionImplementor, null);
        Assert.assertNull((Object)str);
        this.m.assertIsSatisfied();
    }

    @Test
    public void setNotEmpty() throws Exception {
        OracleEmptyStringUserType type = OracleEmptyStringUserType.INSTANCE;
        final PreparedStatement st = (PreparedStatement)this.m.mock(PreparedStatement.class);
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((PreparedStatement)this.oneOf(st)).setString(0, "something");
            }
        });
        type.nullSafeSet(st, (Object)"something", 0, this.sessionImplementor);
        this.m.assertIsSatisfied();
    }

    @Test
    public void setEmpty() throws Exception {
        OracleEmptyStringUserType type = OracleEmptyStringUserType.INSTANCE;
        final PreparedStatement st = (PreparedStatement)this.m.mock(PreparedStatement.class);
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((PreparedStatement)this.oneOf(st)).setString(0, "<EmptyString/>");
            }
        });
        type.nullSafeSet(st, (Object)"", 0, this.sessionImplementor);
        this.m.assertIsSatisfied();
    }

    @Test
    public void setNull() throws Exception {
        OracleEmptyStringUserType type = OracleEmptyStringUserType.INSTANCE;
        final PreparedStatement st = (PreparedStatement)this.m.mock(PreparedStatement.class);
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((PreparedStatement)this.oneOf(st)).setNull(0, 12);
            }
        });
        type.nullSafeSet(st, null, 0, this.sessionImplementor);
        this.m.assertIsSatisfied();
    }

    @Test
    public void copy() throws Exception {
        OracleEmptyStringUserType type = OracleEmptyStringUserType.INSTANCE;
        Assert.assertEquals((Object)"something", (Object)type.deepCopy((Object)"something"));
        Assert.assertEquals((Object)"", (Object)type.deepCopy((Object)""));
        Assert.assertNull((Object)type.deepCopy(null));
    }

    @Test
    public void equals() throws Exception {
        OracleEmptyStringUserType type = OracleEmptyStringUserType.INSTANCE;
        Assert.assertTrue((boolean)type.equals((Object)"something", (Object)"something"));
        Assert.assertTrue((boolean)type.equals(null, null));
        Assert.assertTrue((boolean)type.equals((Object)"", (Object)""));
        Assert.assertTrue((boolean)type.equals((Object)"<EmptyString/>", (Object)"<EmptyString/>"));
        Assert.assertFalse((boolean)type.equals((Object)"", null));
        Assert.assertFalse((boolean)type.equals(null, (Object)""));
    }
}

