/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.impl;

import com.google.common.io.ByteSource;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.Sequence;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.files.FileReference;
import uk.ac.warwick.util.files.HashFileReference;
import uk.ac.warwick.util.files.HashFileStore;
import uk.ac.warwick.util.files.impl.EmptyHashBackedFileReference;

public class EmptyHashBackedFileReferenceTest {
    private final Mockery m = new JUnit4Mockery();
    private final HashFileStore fileStore = (HashFileStore)this.m.mock(HashFileStore.class);
    private final HashFileReference hashRef = (HashFileReference)this.m.mock(HashFileReference.class);
    private static final String STORE_NAME = "fake-bucket-for-test-files";
    private static final byte[] DATA = "Hello".getBytes();

    @Test
    public void testEmptyFileReference() throws Exception {
        EmptyHashBackedFileReference emptyRef = new EmptyHashBackedFileReference(this.fileStore, STORE_NAME);
        final ByteSource bs = ByteSource.wrap((byte[])DATA);
        Assert.assertFalse((boolean)emptyRef.isExists());
        Assert.assertFalse((boolean)emptyRef.isFileBacked());
        Assert.assertFalse((boolean)emptyRef.isLocal());
        Assert.assertNull((Object)emptyRef.getHash());
        Assert.assertNull((Object)emptyRef.getPath());
        Assert.assertEquals((long)0L, (long)emptyRef.length());
        Assert.assertEquals((Object)emptyRef, (Object)emptyRef.renameTo((FileReference)this.hashRef));
        Assert.assertNotEquals((Object)emptyRef, (Object)emptyRef.copyTo((FileReference)this.hashRef));
        Assert.assertEquals((Object)"EmptyHashBackedFileReference", (Object)emptyRef.copyTo((FileReference)this.hashRef).getClass().getSimpleName());
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence seq = EmptyHashBackedFileReferenceTest.this.m.sequence("hashRefSequence");
                ((HashFileStore)this.one(EmptyHashBackedFileReferenceTest.this.fileStore)).createHashReference(bs, EmptyHashBackedFileReferenceTest.STORE_NAME);
                this.inSequence(seq);
                this.will(1.returnValue((Object)EmptyHashBackedFileReferenceTest.this.hashRef));
            }
        });
        FileReference newRef = emptyRef.overwrite(bs);
        Assert.assertEquals((Object)this.hashRef, (Object)newRef);
        this.m.assertIsSatisfied();
    }
}

