/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core.spring;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServer;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.jmx.MBeanServerNotFoundException;
import uk.ac.warwick.util.core.spring.JbossJmxServerLocator;

public class JbossJmxServerLocatorTest {
    private JbossJmxServerLocator locator;
    private Mockery m;

    @Before
    public void setup() throws Exception {
        this.m = new Mockery();
        this.locator = new JbossJmxServerLocator();
    }

    @Test
    public void jbossServerSecond() throws Exception {
        final MBeanServer jconsole = (MBeanServer)this.m.mock(MBeanServer.class, "jconsole");
        final MBeanServer jmx = (MBeanServer)this.m.mock(MBeanServer.class, "jboss-jmx");
        ArrayList servers = Lists.newArrayList((Object[])new MBeanServer[]{jconsole, jmx});
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((MBeanServer)this.one(jconsole)).getDefaultDomain();
                this.will(1.returnValue((Object)"jconsole"));
                ((MBeanServer)this.one(jmx)).getDefaultDomain();
                this.will(1.returnValue((Object)"jboss"));
            }
        });
        Assert.assertEquals((Object)jmx, (Object)this.locator.choose((List)servers));
    }

    @Test
    public void pickFirstIfNoJboss() throws Exception {
        final MBeanServer jconsole = (MBeanServer)this.m.mock(MBeanServer.class, "jconsole");
        final MBeanServer johnsonsMbeanServer = (MBeanServer)this.m.mock(MBeanServer.class, "johnsons-mbean-server");
        ArrayList servers = Lists.newArrayList((Object[])new MBeanServer[]{jconsole, johnsonsMbeanServer});
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((MBeanServer)this.one(jconsole)).getDefaultDomain();
                this.will(2.returnValue((Object)"jconsole"));
                ((MBeanServer)this.one(johnsonsMbeanServer)).getDefaultDomain();
                this.will(2.returnValue((Object)"JOHNSON!"));
            }
        });
        Assert.assertEquals((Object)jconsole, (Object)this.locator.choose((List)servers));
    }

    @Test(expected=MBeanServerNotFoundException.class)
    public void errorIfNoServers() throws Exception {
        this.locator.choose(new ArrayList());
    }
}

