/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core.spring;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.springframework.util.FileCopyUtils;
import uk.ac.warwick.util.AbstractFileBasedTest;
import uk.ac.warwick.util.core.StringUtils;
import uk.ac.warwick.util.core.spring.FileUtils;

public class FileUtilsTest
extends AbstractFileBasedTest {
    public void testTemporaryFile() throws FileNotFoundException, IOException {
        int i;
        int numberOfThreads = 10;
        final ArrayList files = new ArrayList(numberOfThreads);
        final ArrayList contentsArray = new ArrayList(numberOfThreads);
        for (i = 0; i < numberOfThreads; ++i) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    String contents = " the contents " + contentsArray.size();
                    contentsArray.add(contents);
                    ByteArrayInputStream is = new ByteArrayInputStream(StringUtils.create((String)contents));
                    File tmpFile = FileUtils.createFile((String)contents, (InputStream)is, (File)new File(FileUtilsTest.this.root, "/tmp/sb-flows"));
                    files.add(tmpFile);
                }
            };
            r.run();
        }
        FileUtilsTest.assertEquals((String)"sanity test files", (int)numberOfThreads, (int)files.size());
        FileUtilsTest.assertEquals((String)"sanity test contents", (int)numberOfThreads, (int)contentsArray.size());
        for (i = 0; i < numberOfThreads; ++i) {
            File file = (File)files.get(i);
            FileUtilsTest.assertTrue((String)("file " + file + " exists"), (boolean)file.exists());
            byte[] bytes = FileCopyUtils.copyToByteArray((File)file);
            String contents = new String(bytes);
            FileUtilsTest.assertEquals((String)"contents", (String)((String)contentsArray.get(i)), (String)contents);
        }
    }

    public void testGetLowerCaseExtension() {
        FileUtilsTest.assertEquals((String)"flv", (String)FileUtils.getLowerCaseExtension((String)"http://example.com/somewhere/video.FLV"));
    }

    public void testGetFilenameWithoutExtension() {
        FileUtilsTest.assertEquals((String)"fab", (String)FileUtils.getFileNameWithoutExtension((String)"fab.txt"));
        FileUtilsTest.assertEquals((String)"fab.tar", (String)FileUtils.getFileNameWithoutExtension((String)"fab.tar.gz"));
        FileUtilsTest.assertEquals((String)".hidden", (String)FileUtils.getFileNameWithoutExtension((String)".hidden"));
        FileUtilsTest.assertEquals((String)".hidden", (String)FileUtils.getFileNameWithoutExtension((String)".hidden.swp"));
    }
}

