/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core.spring;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import uk.ac.warwick.util.core.spring.FileUtils;

class FileUtilsConvertToSafeFileNameTest {
    FileUtilsConvertToSafeFileNameTest() {
    }

    @Test
    void badCharacters() {
        String[] goodNames = new String[]{"a.gfd", "abc_-012a.abf"};
        String[] badNames = new String[]{"(", ")", "{", "}", ">", "<", "!", "\"", "$", "%", "^", "&", "*", "+", "=", "[", "]", ":", ";", "@", "'", "~", "#", "?", "/", "|"};
        for (String good : goodNames) {
            Assertions.assertEquals((Object)good, (Object)FileUtils.convertToSafeFileName((String)good), (String)("good: " + good));
        }
        for (String bad : badNames) {
            Assertions.assertEquals((Object)"", (Object)FileUtils.convertToSafeFileName((String)bad));
        }
        for (String good : goodNames) {
            for (String bad : badNames) {
                String s = bad + good + bad;
                Assertions.assertEquals((Object)good, (Object)FileUtils.convertToSafeFileName((String)s));
            }
        }
    }

    @Test
    void moreThanOneExtension() {
        String fileName = "ab.c.def";
        String badFileName = ".ab.c.def";
        Assertions.assertEquals((Object)fileName, (Object)FileUtils.convertToSafeFileName((String)badFileName));
    }

    @Test
    void badExtension() {
        String badFileName = "abc.)))";
        String expected = "abc";
        Assertions.assertEquals((Object)expected, (Object)FileUtils.convertToSafeFileName((String)badFileName));
    }

    @Test
    void spacesAreConverted() {
        String badFileName = "a space. tx t";
        String goodFileName = "a-space.tx-t";
        Assertions.assertEquals((Object)goodFileName, (Object)FileUtils.convertToSafeFileName((String)badFileName));
    }

    @Test
    void lowerCaseConverting() {
        String badFileName = "ABCde.GiF";
        String goodFileName = "abcde.gif";
        Assertions.assertEquals((Object)goodFileName, (Object)FileUtils.convertToSafeFileName((String)badFileName));
    }

    @Test
    void pathIsExtracted() {
        String fileName = "abc.def";
        String badFileName = "/gjhsd/sd/abc.def";
        Assertions.assertEquals((Object)fileName, (Object)FileUtils.convertToSafeFileName((String)badFileName));
    }

    @Test
    void lowerAndSpecial() {
        String fileName = "hello-world";
        String badFileName = "Hello?!?!-%world";
        Assertions.assertEquals((Object)fileName, (Object)FileUtils.convertToSafeFileName((String)badFileName));
    }

    @Test
    void cantStopThinking() {
        String filename = "I can't stop thinking.png";
        String safe = "i-cant-stop-thinking.png";
        Assertions.assertEquals((Object)safe, (Object)FileUtils.convertToSafeFileName((String)filename));
    }

    @Test
    void trimmingCollapsingAndDiacritics() {
        String filename = "   It's (high time) we - hm-  think about H\u2082O & Flamb\u00e9e!  .t\ud83e\udd84xt";
        String safe = "its-high-time-we-hm-think-about-h2o-flambee.txt";
        Assertions.assertEquals((Object)safe, (Object)FileUtils.convertToSafeFileName((String)filename));
    }

    @Test
    void convertToSafeFileName() {
        this.verifyFileNameConversion("validfile.xml");
        this.verifyFileNameConversion("properly_formatted_name.txt");
        this.verifyFileNameConversion("Spaced file name.jpg", "spaced-file-name.jpg");
        this.verifyFileNameConversion("CAPITAL.GIF", "capital.gif");
        this.verifyFileNameConversion("excited!.txt", "excited.txt");
        this.verifyFileNameConversion("[b]utilityBar fixes.txt[]", "butilitybar-fixes.txt");
        this.verifyFileNameConversion("'Very elaborate,' file name; maybe.gif", "very-elaborate-file-name-maybe.gif");
        this.verifyFileNameConversion("archive.tar.gz");
        this.verifyFileNameConversion("application-1.0.6-build.zip");
        this.verifyFileNameConversion(".dotstart.zip", "dotstart.zip");
        this.verifyFileNameConversion(".....dotstart.zip", "dotstart.zip");
    }

    private void verifyFileNameConversion(String input, String expected) {
        Assertions.assertEquals((Object)expected, (Object)FileUtils.convertToSafeFileName((String)input));
    }

    private void verifyFileNameConversion(String input) {
        this.verifyFileNameConversion(input, input);
    }
}

