/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core;

import junit.framework.TestCase;
import uk.ac.warwick.util.core.StringUtils;

public class StringUtilsHtmlEscapeTest
extends TestCase {
    public void testNothingEscaped() {
        String input = "<p>Test input, no special characters</p>";
        this.verify(input, input);
    }

    public void testItWorks() {
        String input = "<p>Test high chars " + String.valueOf('\u0093') + "hello" + String.valueOf('\u0094') + "</p>";
        String expected = "<p>Test high chars &#147;hello&#148;</p>";
        this.verify(input, expected);
    }

    public void testAstralPlanes() {
        String input = "Walking man: \ud83d\udeb6";
        String expected = "Walking man: &#128694;";
        this.verify(input, expected);
    }

    private void verify(String input, String expected) {
        StringUtilsHtmlEscapeTest.assertEquals((String)expected, (String)StringUtils.htmlEscapeHighCharacters((String)input));
    }
}

