/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core;

import junit.framework.TestCase;
import org.junit.Test;
import uk.ac.warwick.util.core.StringUtils;

public class StringUtilsAsciiLowercaseTest {
    @Test
    public void doesntMessUpNormalLowercase() {
        String input = "<p>test input, no upper-case characters</p>";
        this.verify(input, input);
    }

    @Test
    public void lowerCasesAsciiCapitals() {
        String input = "<HTML><HEAD></HEAD><BODY><p>Tapirs, so beloved</p></BODY>";
        String expected = "<html><head></head><body><p>tapirs, so beloved</p></body>";
        this.verify(input, expected);
    }

    @Test
    public void remainsUndefeatedByTheTurkishI() {
        String input = "<p>Turkish Translation: <em><a href=\"some-url\" target=\"_blank\" rel=\"noopener\">Venedik Gizli Servisi -R\u00f6nesans\u2019ta Bir \u0130stihbarat Te\u015fkilat\u0131 </a></em>(Istanbul: Kronik Kitap, 2020)</p>";
        String expected = "<p>turkish translation: <em><a href=\"some-url\" target=\"_blank\" rel=\"noopener\">venedik gizli servisi -r\u00f6nesans\u2019ta bir \u0130stihbarat te\u015fkilat\u0131 </a></em>(istanbul: kronik kitap, 2020)</p>";
        this.verify(input, expected);
    }

    private void verify(String input, String expected) {
        TestCase.assertEquals((String)expected, (String)StringUtils.asciiLowerCase((String)input));
    }
}

