/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core;

import javax.servlet.ServletRequest;
import junit.framework.TestCase;
import org.springframework.mock.web.MockHttpServletRequest;
import uk.ac.warwick.util.core.HttpUtils;

public class HttpUtilsTest
extends TestCase {
    public void testIsAbsolutePath() {
        HttpUtilsTest.assertTrue((boolean)HttpUtils.isAbsoluteAddress((String)"http://www.warwick.ac.uk/file.gif"));
        HttpUtilsTest.assertTrue((boolean)HttpUtils.isAbsoluteAddress((String)"www.warwick.ac.uk/file.gif"));
        HttpUtilsTest.assertTrue((boolean)HttpUtils.isAbsoluteAddress((String)"crabs.com/file.gif"));
        HttpUtilsTest.assertFalse((boolean)HttpUtils.isAbsoluteAddress((String)"video.avi"));
        HttpUtilsTest.assertFalse((boolean)HttpUtils.isAbsoluteAddress((String)"super-flash/file.gif"));
        HttpUtilsTest.assertFalse((boolean)HttpUtils.isAbsoluteAddress((String)"blah/relative.htm/feet/file.gif"));
        HttpUtilsTest.assertFalse((boolean)HttpUtils.isAbsoluteAddress((String)"../super-flash/file.gif"));
        HttpUtilsTest.assertTrue((boolean)HttpUtils.isAbsoluteAddress((String)"relative.fish/feet/file.gif"));
    }

    public void testGetBooleanRequestAttribute() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        HttpUtilsTest.assertFalse((boolean)HttpUtils.getBooleanRequestAttribute((ServletRequest)request, (String)"test", (boolean)false));
        HttpUtilsTest.assertTrue((boolean)HttpUtils.getBooleanRequestAttribute((ServletRequest)request, (String)"test", (boolean)true));
        request.setAttribute("test", (Object)false);
        HttpUtilsTest.assertFalse((boolean)HttpUtils.getBooleanRequestAttribute((ServletRequest)request, (String)"test", (boolean)false));
        HttpUtilsTest.assertFalse((boolean)HttpUtils.getBooleanRequestAttribute((ServletRequest)request, (String)"test", (boolean)true));
        request.setAttribute("test", (Object)false);
        HttpUtilsTest.assertFalse((boolean)HttpUtils.getBooleanRequestAttribute((ServletRequest)request, (String)"test", (boolean)false));
        HttpUtilsTest.assertFalse((boolean)HttpUtils.getBooleanRequestAttribute((ServletRequest)request, (String)"test", (boolean)true));
        request.setAttribute("test", (Object)Boolean.TRUE);
        HttpUtilsTest.assertTrue((boolean)HttpUtils.getBooleanRequestAttribute((ServletRequest)request, (String)"test", (boolean)false));
        HttpUtilsTest.assertTrue((boolean)HttpUtils.getBooleanRequestAttribute((ServletRequest)request, (String)"test", (boolean)true));
    }
}

