/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core;

import java.util.List;
import junit.framework.TestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import uk.ac.warwick.util.core.HtmlUtils;

public class HtmlUtilsTest
extends TestCase {
    public void testEscapeHtmlForAscii() {
        String input = "<html>Yes? \u0414\u0430! (&copy; 2008)</html>";
        String expected = "<html>Yes? &#x414;&#x430;! (&copy; 2008)</html>";
        String result = HtmlUtils.htmlEscapeNonAscii((String)input);
        HtmlUtilsTest.assertEquals((String)expected, (String)result);
    }

    @Test
    public void testExtractContentsVsSpecialCharacters() {
        String contentWithSpecialCharacters = "<html><head></head><body><p>Turkish Translation: <em><a href=\"https://kronikkitap.com/kitap/venedik-gizli-servisi/\" target=\"_blank\" rel=\"noopener\">Venedik Gizli Servisi -R\u00f6nesans\u2019ta Bir \u0130stihbarat Te\u015fkilat\u0131 </a></em>(Istanbul: Kronik Kitap, 2020)</p></body></html>";
        List results = HtmlUtils.extractContent((String)contentWithSpecialCharacters, (String)"<body", (String)"</body>");
        results.forEach(result -> MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.endsWith((String)">")));
    }
}

