/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core;

import junit.framework.TestCase;
import uk.ac.warwick.util.core.spring.FileUtils;

public final class FileNameExtensionSplitterTest
extends TestCase {
    public void testNoExtension() {
        String fileName = "abcde";
        FileNameExtensionSplitterTest.assertEquals((String)fileName, (String)FileUtils.getFileNameWithoutExtension((String)fileName));
        FileNameExtensionSplitterTest.assertEquals((String)"", (String)FileUtils.getLowerCaseExtension((String)fileName));
    }

    public void testMoreThanOneExtension() {
        String fileNameWithBadExtension = "abcde.ext";
        String extension = "abc";
        String fileName = fileNameWithBadExtension + "." + extension;
        FileNameExtensionSplitterTest.assertEquals((String)"fileName", (String)fileNameWithBadExtension, (String)FileUtils.getFileNameWithoutExtension((String)fileName));
        FileNameExtensionSplitterTest.assertEquals((String)"extension", (String)extension, (String)FileUtils.getLowerCaseExtension((String)fileName));
    }

    public void testExtension() {
        String fileNameWithOutExtension = "abcde";
        String extension = "abc";
        String fileName = fileNameWithOutExtension + "." + extension;
        FileNameExtensionSplitterTest.assertEquals((String)"fileName", (String)fileNameWithOutExtension, (String)FileUtils.getFileNameWithoutExtension((String)fileName));
        FileNameExtensionSplitterTest.assertEquals((String)"extension", (String)extension, (String)FileUtils.getLowerCaseExtension((String)fileName));
    }

    public void testWithTrailingSlash() {
        String fileNameWithOutExtension;
        String fileName = fileNameWithOutExtension = "abcde";
        FileNameExtensionSplitterTest.assertEquals((String)"fileName", (String)fileName, (String)FileUtils.getFileNameWithoutExtension((String)(fileName + ".")));
        FileNameExtensionSplitterTest.assertEquals((String)"extension", (String)"", (String)FileUtils.getLowerCaseExtension((String)fileName));
    }

    public void testCompareExtensions() {
        String filename = "foobar.baz";
        FileNameExtensionSplitterTest.assertTrue((String)"Extension match failed", (boolean)FileUtils.extensionMatches((String)filename, (String)"baz"));
        FileNameExtensionSplitterTest.assertTrue((String)"Extension match failed", (boolean)FileUtils.extensionMatches((String)filename, (String)".baz"));
        FileNameExtensionSplitterTest.assertTrue((String)"Extension match failed", (boolean)FileUtils.extensionMatches((String)filename, (String)".BAZ"));
        FileNameExtensionSplitterTest.assertTrue((String)"Extension match failed", (boolean)FileUtils.extensionMatches((String)filename, (String)"BaZ"));
        FileNameExtensionSplitterTest.assertFalse((String)"Extension match succeeded unexpectedly!", (boolean)FileUtils.extensionMatches((String)filename, (String)"ba"));
        FileNameExtensionSplitterTest.assertFalse((String)"Extension match succeeded unexpectedly!", (boolean)FileUtils.extensionMatches((String)filename, (String)"az"));
    }
}

