/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.core.DateTimeUtils;

public final class DateTimeUtilsTest {
    @Test
    public void equalsIgnoreTime() {
        LocalDateTime twelfthMorning = this.makeDateTime(12, 10);
        LocalDateTime twelfthEvening = this.makeDateTime(12, 16);
        LocalDateTime eleventhMorning = this.makeDateTime(11, 10);
        Assert.assertTrue((boolean)DateTimeUtils.equalsIgnoreTime((Temporal)twelfthMorning, (Temporal)twelfthEvening));
        Assert.assertTrue((boolean)DateTimeUtils.equalsIgnoreTime((Temporal)twelfthEvening, (Temporal)twelfthMorning));
        Assert.assertFalse((boolean)DateTimeUtils.equalsIgnoreTime((Temporal)twelfthMorning, (Temporal)eleventhMorning));
        Assert.assertFalse((boolean)DateTimeUtils.equalsIgnoreTime((Temporal)twelfthEvening, (Temporal)eleventhMorning));
    }

    @Test
    public void isSameDay() {
        LocalDate dt = LocalDate.of(2009, 1, 1);
        Assert.assertTrue((boolean)DateTimeUtils.isSameDay((Temporal)dt, (Temporal)dt.atTime(15, 1, 1, 0)));
        Assert.assertFalse((boolean)DateTimeUtils.isSameDay((Temporal)dt, (Temporal)dt.plusDays(1L)));
        Assert.assertTrue((boolean)DateTimeUtils.isSameDay((Temporal)dt, (Temporal)dt.plusDays(0L)));
    }

    @Test
    public void getDifferenceInDays() {
        LocalDateTime dt = LocalDateTime.of(2009, 1, 1, 1, 0, 0, 0);
        Assert.assertEquals((long)0L, (long)DateTimeUtils.getDifferenceInDays((Temporal)dt, (Temporal)dt.plusHours(1L)));
        Assert.assertEquals((long)1L, (long)DateTimeUtils.getDifferenceInDays((Temporal)dt, (Temporal)dt.plusDays(1L)));
        Assert.assertEquals((long)1L, (long)DateTimeUtils.getDifferenceInDays((Temporal)dt, (Temporal)dt.plusDays(1L).plusHours(1L)));
        Assert.assertEquals((long)30L, (long)DateTimeUtils.getDifferenceInDays((Temporal)dt, (Temporal)dt.plusDays(30L)));
        Assert.assertEquals((long)30L, (long)DateTimeUtils.getDifferenceInDays((Temporal)dt, (Temporal)dt.plusDays(30L).plusHours(1L)));
    }

    @Test
    public void getDifferenceInWeeks() {
        LocalDateTime dt = LocalDateTime.of(2009, 1, 1, 1, 0, 0, 0);
        Assert.assertEquals((long)0L, (long)DateTimeUtils.getDifferenceInWeeks((Temporal)dt, (Temporal)dt.plusHours(1L)));
        Assert.assertEquals((long)1L, (long)DateTimeUtils.getDifferenceInWeeks((Temporal)dt, (Temporal)dt.plusWeeks(1L)));
        Assert.assertEquals((long)1L, (long)DateTimeUtils.getDifferenceInWeeks((Temporal)dt, (Temporal)dt.plusWeeks(1L).plusHours(1L)));
        Assert.assertEquals((long)2L, (long)DateTimeUtils.getDifferenceInWeeks((Temporal)dt, (Temporal)dt.plusDays(8L)));
        Assert.assertEquals((long)5L, (long)DateTimeUtils.getDifferenceInWeeks((Temporal)dt, (Temporal)dt.plusWeeks(5L)));
        Assert.assertEquals((long)5L, (long)DateTimeUtils.getDifferenceInWeeks((Temporal)dt, (Temporal)dt.plusWeeks(5L).plusHours(1L)));
    }

    @Test
    public void mockInstant() {
        Instant now = Instant.ofEpochMilli(1550766083416L);
        DateTimeUtils.useMockDateTime((TemporalAccessor)now, () -> Assert.assertEquals((Object)Instant.now(DateTimeUtils.CLOCK_IMPLEMENTATION), (Object)now));
    }

    @Test
    public void mockOffsetDateTime() {
        OffsetDateTime now = Instant.ofEpochMilli(1550766083416L).atOffset(ZoneOffset.UTC);
        DateTimeUtils.useMockDateTime((TemporalAccessor)now, () -> Assert.assertEquals((Object)OffsetDateTime.now(DateTimeUtils.CLOCK_IMPLEMENTATION), (Object)now));
    }

    @Test
    public void mockLocalDateTime() {
        LocalDateTime now = Instant.ofEpochMilli(1550766083416L).atOffset(ZoneOffset.UTC).toLocalDateTime();
        DateTimeUtils.useMockDateTime((TemporalAccessor)now, () -> Assert.assertEquals((Object)LocalDateTime.now(DateTimeUtils.CLOCK_IMPLEMENTATION), (Object)now));
    }

    @Test
    public void mockZonedDateTime() {
        ZonedDateTime now = Instant.ofEpochMilli(1550766083416L).atZone(ZoneId.systemDefault());
        DateTimeUtils.useMockDateTime((TemporalAccessor)now, () -> Assert.assertEquals((Object)ZonedDateTime.now(DateTimeUtils.CLOCK_IMPLEMENTATION), (Object)now));
    }

    private LocalDateTime makeDateTime(int date, int hour) {
        return LocalDate.of(2006, 11, date).atTime(LocalTime.now().withHour(hour));
    }
}

