/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.texttransformers.TextPatternTransformer;

public final class TextPatternTransformerTest {
    @Test
    public void applyWithHeads() throws Exception {
        TextPatternTransformer transformer = new TextPatternTransformer(){

            protected Pattern getPattern() {
                return Pattern.compile("\\[add-head(\\s+.+?[^\\\\])?\\](.+?)\\[/add-head\\]", 2);
            }

            protected boolean isGeneratesHead() {
                return true;
            }

            protected TextPatternTransformer.Callback getCallback() {
                return new TextPatternTransformer.Callback(){

                    public String transform(String input, MutableContent mc) {
                        Matcher matcher = this.getPattern().matcher(input);
                        matcher.matches();
                        String contents = matcher.group(2);
                        return "<html><head>" + contents + "</head><body>" + contents + "</body></html>";
                    }
                };
            }
        };
        MutableContent mc = new MutableContent(null, "<p>[add-head]head1[/add-head]</p>\n\n<p>[add-head]head2[/add-head]</p>");
        mc = transformer.apply(mc);
        Assert.assertEquals((Object)"<html><head>head1head2</head><body><p>head1</p>\n\n<p>head2</p></body></html>", (Object)mc.getContent());
    }

    @Test
    public void applyWithHeadsWithExistingHtml() throws Exception {
        TextPatternTransformer transformer = new TextPatternTransformer(){

            protected Pattern getPattern() {
                return Pattern.compile("\\[add-head(\\s+.+?[^\\\\])?\\](.+?)\\[/add-head\\]", 2);
            }

            protected boolean isGeneratesHead() {
                return true;
            }

            protected TextPatternTransformer.Callback getCallback() {
                return new TextPatternTransformer.Callback(){

                    public String transform(String input, MutableContent mc) {
                        Matcher matcher = this.getPattern().matcher(input);
                        matcher.matches();
                        String contents = matcher.group(2);
                        return "<html><head>" + contents + "</head><body>" + contents + "</body></html>";
                    }
                };
            }
        };
        MutableContent mc = new MutableContent(null, "<html><body><p>[add-head]head1[/add-head]</p>\n\n<p>[add-head]head2[/add-head]</p></body></html>");
        mc = transformer.apply(mc);
        Assert.assertEquals((Object)"<html><head>head1head2</head><body><p>head1</p>\n\n<p>head2</p></body></html>", (Object)mc.getContent());
    }

    @Test
    public void applyWithHeadsWithExistingHead() throws Exception {
        TextPatternTransformer transformer = new TextPatternTransformer(){

            protected Pattern getPattern() {
                return Pattern.compile("\\[add-head(\\s+.+?[^\\\\])?\\](.+?)\\[/add-head\\]", 2);
            }

            protected boolean isGeneratesHead() {
                return true;
            }

            protected TextPatternTransformer.Callback getCallback() {
                return new TextPatternTransformer.Callback(){

                    public String transform(String input, MutableContent mc) {
                        Matcher matcher = this.getPattern().matcher(input);
                        matcher.matches();
                        String contents = matcher.group(2);
                        return "<html><head>" + contents + "</head><body>" + contents + "</body></html>";
                    }
                };
            }
        };
        MutableContent mc = new MutableContent(null, "<html><head>something</head><body><p>[add-head]head1[/add-head]</p>\n\n<p>[add-head]head2[/add-head]</p></body></html>");
        mc = transformer.apply(mc);
        Assert.assertEquals((Object)"<html><head>somethinghead1head2</head><body><p>head1</p>\n\n<p>head2</p></body></html>", (Object)mc.getContent());
    }
}

