/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.textile2;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import uk.ac.warwick.util.content.textile2.TextileString;

class TextileStringTest {
    TextileStringTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        System.setProperty("textile.media.mp3WimpyPlayerLocation", "wimpy.swf");
        System.setProperty("textile.media.mp3AlternatePlayerLocation", "mp3player.swf");
        System.setProperty("textile.media.quicktimePreviewImage", "qt.png");
        System.setProperty("textile.media.windowsMediaPreviewImage", "wmp.jpg");
        System.setProperty("textile.media.flvPlayerLocation", "flyplayer.swf");
        System.setProperty("textile.latex.location", "/cgi-bin/mimetex.cgi");
    }

    @Test
    public void noTrailingSpaceInLinks() throws Exception {
        String input = "Here is the first line\n\nHere is the second line, http://www.warwick.ac.uk. Whoopie!\n\nHere is the third line";
        String output = this.convertForums(input);
        String expected = "<p>Here is the first line</p>\t<p>Here is the second line, <a rel=\"nofollow\" href=\"http://www.warwick.ac.uk\">http://www.warwick.ac.uk</a>. Whoopie!</p>\t<p>Here is the third line</p>";
        Assertions.assertEquals((Object)expected, (Object)output.replace("\n", ""));
    }

    public String convertForums(String input) {
        TextileString textileString = new TextileString(input);
        textileString.setCorrectHtml(true);
        textileString.setDisallowTags("script,style,link,blink,object,applet,canvas");
        textileString.setAddNoFollow(true);
        textileString.setAllowJavascriptHandlers(false);
        String formattedText = textileString.getHtml();
        if (formattedText == null) {
            Assertions.fail((String)("Error formatting text, null value returned for: " + input));
        }
        return formattedText;
    }
}

